/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/


/*******************************************************************************
 * Declare perspectives
 */
(function(__){
	/***********************************************************
	 * Common processing for declaration
	 */
	var pers = {}
	,declareLayout = function(per_nm, p_object){
		var per   = {}
		,p_lays   // layout of p_object
		,p_opts
		,views
		,layouts  = []
		,properties // private properties
		,lay_spls = [
			["north", "center", "south"]
			,["west", "center", "east"]
			,["south", "center", "north"]
			,["east", "center", "west"]
		]
		,setLayOpt = function(p_opts, len, func, lay_no){
			var type
			,lay_spl
			,lay_opt = {} // return options
			;
			
			// Set type, default 0
			if((typeof p_opts[0] == "number")
				&& (0 < p_opts[0]) && (p_opts[0] < 4)){
				type = Math.floor(p_opts[0]);
			}else{
				type = 0;
			}
			
			// Get layout
			lay_spl = lay_spls[type];
			
			// Really need a layout: the number of dom is greater than 1
			if(len > 1){
				// Set size options
				if(p_opts[1]){
					// Set opt
					lay_opt[lay_spl[0] + "__size"] = p_opts[1];
					
					// Set opt the second size
					if(p_opts[2]){
						lay_opt[lay_spl[2] + "__size"] = p_opts[2];
					}
				}
				
				// set selector options
				for(var cnt = 0; cnt < len; cnt++){
					lay_opt[[lay_spl[cnt], "__paneSelector"].join("")] =
						__[func](per_nm, cnt, lay_no);
				}
			}else{
				// A pane, only set selector for center
				lay_opt["center__paneSelector"] = __[func](per_nm, 0, lay_no);
			}
			
			return lay_opt;
		}
		;
		
		/*****************************************
		 * Check validation for declaring layout perspective
		 */
		// Get name of perspective
		if(!(per_nm && ((typeof per_nm) == "string"))){
			return;
		}
		
		// check if name exists
		if(__[per_nm]){
			return;
		}
		
		// Add perspective to list perspectives
		pers[per_nm] = per;
		
		/*****************************************
		 * Constructor perspective
		 */
		/*
		 * Set layout title and name for perspective
		 */
		per._title = __.getPersTitle(per_nm);
		per._name  = per_nm;
		
		// Check declaring layout object
		if(!(p_object && ((typeof p_object) == "object"))){
			// Set p_object is a empty object
			p_object = {};
		}
		
		/*
		 * Set views
		 */
		if(views = p_object.views){
			per._views = views;
			for(var view_nm in views){
				// Initialize
				per[view_nm] = {};
				
				// Add properties for view
				$.extend(per[view_nm], {
					_name       : view_nm
					,_title     : __.getViewTitle(per_nm, view_nm)
					,updateData : function(obj){
						var _ = this
						,content
						;
						
						if(!(obj && ((typeof obj) == "object"))){
							return;
						}
						
						// Store private inform
						for(var prop in obj){
							// Add __ to prevent duplication.
							_[["__", prop].join("")] = obj[prop];
						}
						
						if(content = _.content){
							if(_._init && content.updateData){
								content.updateData();
							}}
					}
					,setRefresh: function(){
						var _     = this
						,inv_min  = 60000  // One minute: 60*1000 milliseconds
						,inv_dft  = 600000 // The interval default value is 10
						                   // minutes: 10*60*1000 milliseconds
						,interval = __.config(["interval", per_nm, _._name].join("_"))
						;
						
						// Check timeout id
						if(_._timeout_id){ // != false, 0, "", null, undefined
							clearTimeout(_._timeout_id);
						}
						// Check validation of type of interval
						if((typeof interval) != "number"){
							interval = inv_dft;
						}
						
						// Check validation of value of interval
						if(interval < inv_min){
							interval = inv_min;
						}
						
						// Set timeout to call refreshData
						_._timeout_id = setTimeout(function(){
							_.refreshData();
						}, interval);
					}
					,refreshData : function(){
						var _ = this
						,content
						;
						if(content = _.content){
							if(content.refreshData && _._init){
								content.refreshData();
							}}
						
						// reset value of _timeout_id
						_._timeout_id = 0;
					}
				});
			}
		}else{
			per._views = {}
		}
		
		/*
		 * Construct main layout
		 */
		// Check layout of object, it must be a array not empty
		if(!((p_lays = p_object.layout) && $.isArray(p_lays) && (p_lays.length))){
			// Set p_lays is a array contains a empty array
			p_lays = [[]];
		}
		
		// Construct layout for perspective
		per._layout = layouts;
		
		// Get length of layouts, max is 3
		var lens = Math.min(p_lays.length, 3);
		
		// Set options
		if(!((p_opts = p_object.option) && $.isArray(p_opts) && (p_opts.length))){
			// Set default option
			p_opts = [0];
		}
		
		// Set option for main layout
		layouts.option = $.extend({}, setLayOpt(p_opts, lens, "layout2Selr"));
		
		// Storage number panel
		layouts.lens = []
		
		/*
		 * Construct for element layout
		 */
		for(var cnt = 0; cnt < lens; cnt++){
			var len
			,opts = p_lays[cnt]
			;
			
			// Check validation of array
			if(!($.isArray(opts) && (opts.length))){
				// Set default option
				opts = [0];
			}
			
			// get length of element layout
			len = Math.min(opts.length, 3);
			
			// Set option for element layout
			layouts[cnt] = $.extend({} ,setLayOpt(opts, len, "panel2Selr", cnt));
			
			// Storage length
			layouts.lens[cnt] = len;
		}
		
		/*
		 * Add list (dialog) title and function get (dialog) title
		 */
		$.extend(per, {
			_lst_ttl : __.getDlgTitle(per_nm)
			,getTitle: function(key){
				var _    = this
				,lst_ttl = _._lst_ttl
				;
				// Check title
				if(lst_ttl[key]){
					return lst_ttl[key];
				}else{
					return key;
				}
			}
		});
		
		/*
		 * Add private properties for perspective
		 */
		if(properties = p_object.properties){
			$.extend(per, properties);
		}
	}
	;
	
	/***********************************************************
	 * Declaration for perspectives
	 */
	/*
	 * Monitor perspective
	 */
	declareLayout("monitor", {
		layout: [
			[0, 0.33, 0.34]
		]
		,views: {
			scope  : [0, 0]
			,status: [0, 1]
			,event : [0, 2]
		}
	});
	
	/*
	 * Repository perspective
	 */
	declareLayout("repository", {
		layout : [
			[0, 0.7]
			,[0]
		]
		,option: [1, .6]
		,views : {
			node            : [0, 0]
			,agent          : [0, 0]
			,scope          : [0, 1]
			,assigned_scopes: [0, 1]
			,node_property  : [1, 0]
		}
	});
	
	/*
	 * Job perspective
	 */
	declareLayout("jobmanagement", {
		properties: {
			openTreeJobDlg: function(input){
				var _ = this // This perspective
				,tree = {
					title     : __.getLang("select_job")
					,data     : _.job_tree.get()
					,key      : "jobId"
					,input    : input
					,checkValue: function(value){
						if(value && value.data && value.data.jobId){
							return true;
						}
						return false;
					}
					,showInform: function(){
						__.openPromptDlg({
							message: {
								content: __.getLang("specify_job")
								,title : __.getLang("select_job_errormsg_title")
							}
							,level : __.LEVEL_WARNING
						});
					}
				}
				;
				
				__.openTreeDlg(tree);
			}
			,job_tree: {
				data: null
				,getData : function(init){
					var _   = this
					,option = {
						url      : "get_job_tree"
						,cache   : false
						,dataType: "json"
						,type    : "get"
						,success : function(data_respond){
							var tree_data;
							
							// Check validation of data_respond
							if(!(__.checkJsonError(data_respond))){
								return;
							}
							
							if(tree_data = data_respond.jobTree){
								// Set tree data
								_.data = tree_data[0];
							}
							/** Bug_154 */
							__.jobmanagement.list.content.tree.refreshData(_.get());
							/***********/
						}
						,error   : __.loadDataError
					}
					;
					
					// Check initialize
					if(init === true){
						$.extend(option, {async: false});
					}
					
					// Get data of tree job
					$.ajax(option);
				}
				,get     : function(){
					var _ = this;
					
					// Check for update
					if(_.data === null){
						/** Bug_154 */
						//_.getData(true);
						_.data = {"addClass":"dynatree-ico-job-blank","children":[],"facilityId":"","isFolder":true,"jobId":"","path":"","jobunitId":"","title":"","tooltip":""};
						/***********/
					}
					
					// Clone tree and return
					return $.extend(true, {}, _.data, {expand : true});
				}
			}
		}
		,layout   : [
			[0, 0.33, 0.34]
		]
		,views    : {
			list                : [0, 0]
			,schedule           : [0, 0]
			,history            : [0, 0]
			,job_detail         : [0, 1]
			,node_detail        : [0, 2]
			,forward_file       : [0, 2]
		}
	});
	
	/***********************************************************
	 * Assign perspectives
	 */
	$.extend(__, pers);
	
})(cm);
