/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

/*******************************************************************************
 * Create monitor status
 */
var fn = function(_view){
	var __ = cm
	,_pers = this
	;
	
	 var view = $.extend({}, __._fnview_tree_grid, {
		load_flg    : false
		,facility_id: ""
		,/*
		 * Set caption of grid
		 */
		setCaption: function(path){
			var _    = this
			,caption = [__.getLang("scope"), ": " , path].join("")
			;
			
			// Check filter
			if(!(_.filter_active)){
				_.grid.setCaption(caption);
			}
			
			// Store caption
			_._caption = caption;
		}
		
		,/*
		 * On click a node of tree
		 */
		onclickTree: function(node_data){
			var _ = this
			;
			_.facility_id = node_data.facilityId;
			_.setCaption(node_data.path);
			
			if (!(_.load_flg)) {
				_.load_flg = true;
				_.reloadGrid();
			}
		}
		
		,/*
		 * reload Grid
		 */
		reloadGrid: function(){
			var _ = this
			;
			
			_.grid.refreshData({
				facilityId: _.facility_id
			});
		}
		
		,/*
		 * Get status list
		 */
		createGrid: function(){
			var _ = this;
			
			// Declare caption
			var caption = _._caption = [__.getLang("scope"), ": "].join("");
			
			$.ajax({
				url      : "get_status_list_table_define"
				,cache   : false
				,dataType: "json"
				,type    : "get"
				,success : function(data_respond){
					// Cache local variants
					var grid = _.grid
					,pager   = grid.$pgr
					;
					
					// Check validation of data_respond
					if (__.checkJsonError(data_respond) !== true){
						return;
					}
					
					// Set some options for grid
					$.extend(data_respond,{
						url          : "get_status_list"
						,pager       : pager
						,caption     : caption
						,sortable    : true
						,viewrecords : true
						,loadComplete: function(){
							var post_data = grid.getGridParam("postData")
								,facility_id
								;
							if((facility_id = post_data.facilityId) === undefined){
								facility_id = "";
							}
							if(facility_id === _.facility_id){
								_.load_flg = false;
							}else{
								setTimeout(function(){
									_.reloadGrid();
								}, 1);
							}
						// Set refresh data
							_view.setRefresh();
							
							// Set priority bar
							_.setPriorityStatusBar();
						}
					});
							
					/** Bug_11 */
					grid.processData(data_respond, ['priority', 'pluginId', 'monitorId', 'monitorDetailId',
						'facilityId', 'application', 'outputTime', 'messageId', 'message'],
						{outputTime: 'hnmDatetime'});
					/***********/
					grid.controlSize();
					
					// Bind action for grid
					// Bind context menu for grid(right click)
					grid.contextMenu(
						"menu_rightclick"
						,{
							onContextMenu: function(event){
								grid.setSelection($(event.target).parent("tr").attr("id"));
								return true;
							}
							,container   : grid.$ctn
						}
					);
				}
				,error   : _.loadDataError
			});
		}
	 	
		,/*
		 * Get facility tree
		 */
		getTree: function(){
			return __.fclt_tree.get(this._id);
		}
		
		,/*
		 * Reset data of panes of views
		 */
		resetView: function(tree){
			var _ = this;
			
			_.tree.refreshData(tree);
			_.facility_id = "";
			_.grid.refreshData({
				facilityId: ""
			}, true);
			
			_.setCaption("");
		}
		
		,/*
		 * Refresh data
		 */
		refreshData: function(){
			/** Bug_11 */
			this.grid.refreshData(null, true);
			/***********/
		}
		
		,/*
		 * Create dialogs
		 */
		createDialog: function(){
			// Cache local variant
			var _ = this;
			
			// Declare filter dialog
			__.crePropActnDlg.call(_, "filter", {
				option: {
					title   : _pers.getTitle("filter_status")
					,width  : 400
					,height : 330
					,open   : function(){
						$(this).siblings('div.ui-dialog-buttonpane:first').find("button:eq(1)").focus();
					}
					,buttons: [
						{
							text  : __.getLang("clear")
							,click: function(){
								_.filter.reset("filter");
							}
						}
						,{
							text  : __.getLang("ok_o")
							,click: function(){
								_.filter.execute(function(post_data){
									var _ = this;
									
									// Extend filter is true
									$.extend(post_data, {filter: true});
									
									// Refresh data
									/** Bug_11 */
									_.grid.refreshData(post_data, true);
									/***********/
									
									// Store filter active
									_.filter_active = true;
									
									// Set caption
									_.grid.setCaption(__.getLang("filtered_list"));
									
									// Add class button active
									_.$btns.children("#filter").addClass("ui-button-active");
								});
								
								$(this).dialog("close");
							}
						}
						,{
							text  : __.getLang("cancel")
							,click: function(){
								_.filter.storeValues();
								$(this).dialog("close");
							}
						}
					]
				}
				,url  : "get_status_filter_property"
			});
		}
		
		,/*
		 * Bind some action
		 */
		bindAction: function(){
			var _ = this
			,btns = _.$btns
			,grid = _.grid
			
			// Bind actions for button in left of pane
			// Bind filter
			btns.children("#filter").click(function(){
				if(_.filter_active){
					// Inactive filter for filter grid
					/** Bug_11 */
					grid.refreshData({filter: false}, true);
					/***********/
					grid.setCaption(_._caption);
					
					// Process CSS for button
					$(this).removeClass("ui-button-active");
					_.filter_active = false;
				}else{
					// Open dialog which contain filter property grid
					_.filter.open();
				}
			});
			
			// Bind update grid data
			btns.children("#update").click(function(){
				/** Bug_11 */
				_.grid.refreshData(null, true);
				/***********/
			});
			// Bind toggle left pane
			btns.children("#toggle_view").click(function(){
				_.togglePane("west", this);
			});
		}
	});
	
	return view;
};