/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.accesscontrol.servlet;

import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.accesscontrol.bean.UserBean;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;

/**
 * 初期表示ログイン画面のサブレットを定義するクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class LoginServlet extends HttpServlet {

    private static final long serialVersionUID = 8524643650658167194L;

    private static Logger m_log = Logger.getLogger(CommonServlet.class);

    /**
     * Handles the HTTP <code>GET</code> method.
     * 
     * @param request
     *            servlet request
     * @param response
     *            servlet response
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        // Initialize environment
        try {
            initEnvironment(request, response);
        } catch (IOException e) {
            m_log.error(e.getMessage());
        }

        // 中間変数を宣言
        String localAddr = request.getLocalAddr();
        HttpSession session = request.getSession(true);

        // セッションからuserBeanを取得
        UserBean userBean = (UserBean) session.getAttribute(AccessControlConstants.USER_BEAN);

        if (userBean == null) {
            userBean = setDefaultUserBean(localAddr);

            // セッションにuserBeanを登録
            session.setAttribute(AccessControlConstants.USER_BEAN, userBean);
        }

        // login.jspにフォワードする
        try {
            getServletContext().getRequestDispatcher(
                    "/jsp/accesscontrol/login.jsp").forward(request, response);
        } catch (Exception e) {
            m_log.error(e.getMessage());
        }
    }

    /**
     * Handles the HTTP <code>POST</code> method.
     * 
     * @param request
     *            servlet request
     * @param response
     *            servlet response
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        doGet(request, response);
    }

    private void initEnvironment(HttpServletRequest request,
            HttpServletResponse response) throws IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
    }

    public UserBean setDefaultUserBean(String localAddress) {
        // 非存在の場合、
        UserBean userBean = new UserBean();
        userBean.setUserName(AccessControlConstants.HINEMOS_USER_DEFAULT);
        userBean.setUrlServer(AccessControlConstants.HINEMOS_HTTP_PROTOCAL_DEFAULT
                + localAddress
                + AccessControlConstants.HINEMOS_HTTP_PORT_DEFAULT);
        return userBean;
    }
}
