/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.accesscontrol.util;

import javax.xml.ws.WebServiceException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.ws.access.AccessEndpoint;
import com.clustercontrol.ws.access.HinemosUnknown_Exception;
import com.clustercontrol.ws.access.InvalidRole_Exception;
import com.clustercontrol.ws.access.InvalidUserPass_Exception;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.EndpointManager.EndpointSetting;

/**
 * Hinemosマネージャとの通信をするクラス。
 * HAのような複数マネージャ対応のため、このクラスを実装する。
 * 
 * Hinemosマネージャと通信できない場合は、WebServiceExceptionがthrowされる。
 * WebServiceExeptionが出力された場合は、もう一台のマネージャと通信する。
 */
public class AccessEndpointWrapper {

	// ログ
	private static Log m_log = LogFactory.getLog( AccessEndpointWrapper.class );

	public static void checkLogin(EndpointManager endpointManager) 
	    throws HinemosUnknown_Exception, InvalidRole_Exception, 
	    InvalidUserPass_Exception, WebServiceException {
		WebServiceException wse = null;
		for (EndpointSetting endpointSetting : endpointManager.getAccessEndpoint()) {
			try {
				AccessEndpoint endpoint = (AccessEndpoint) endpointSetting.getEndpoint();
				endpoint.checkLogin();
				return;
			} catch (WebServiceException e) {
				wse = e;
				m_log.warn("checkLogin(), " + e.getMessage(), e);
				endpointManager.changeEndpoint();
			}
		}
		throw wse;
	}
}
