/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.accesscontrol.util;

import javax.servlet.http.HttpSession;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * ログインに関するセッションを管理するクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class LoginSessionManager {

    // タイムアウトセッション（単位：秒）
    public static final int SESSION_TIMEOUT = 1800;

    // すでにログインするかどうかチェック
    public static boolean checkLogin(HttpSession session) {
        if (session == null || (null == session.getAttribute(AccessControlConstants.LOGIN_MANAGER))) {
            return false;
        }

        session.setMaxInactiveInterval(SESSION_TIMEOUT);
        
        return true;
    }

    // Hinemosマネージャからログアウトする
    public static void processLogout(HttpSession session) {
        processLogout(session, true);
    }

    public static void processLogout(HttpSession session, boolean invalidSession) {
        // セッションにloginManagerの存在チェック
        LoginManager loginManager = (LoginManager) session
                .getAttribute(AccessControlConstants.LOGIN_MANAGER);
        if (loginManager != null) {
            session.removeAttribute(AccessControlConstants.LOGIN_MANAGER);
        }
        
        if (invalidSession) {
            session.invalidate();
        }
    }
}