/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.bean;

import java.util.Locale;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * 重要度の定義を定数として格納するクラス<BR>
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class PriorityConstant {

    /** 危険（種別）。 */
    public static final int TYPE_CRITICAL = 0;

    /** 警告（種別）。 */
    public static final int TYPE_WARNING = 2;

    /** 通知（種別）。 */
    public static final int TYPE_INFO = 3;

    /** 不明（種別）。 */
    public static final int TYPE_UNKNOWN = 1;

    /** なし（種別）。 */
    public static final int TYPE_NONE = 4;

    /** なし（文字列）。 */
    public static final String STRING_NONE = "";

    /**
     * 文字列から種別に変換します。<BR>
     * 
     * @param string 文字列
     * @return 種別
     */
    public static int stringToType(String string, Locale locale) {
        if (string.equals(WebMessages.getString("critical", locale))) {
            return TYPE_CRITICAL; //危険（文字列）
        } else if (string.equals(WebMessages.getString("warning", locale))) {
            return TYPE_WARNING; //警告（文字列）
        } else if (string.equals(WebMessages.getString("info", locale))) {
            return TYPE_INFO; //通知（文字列）
        } else if (string.equals(WebMessages.getString("unknown", locale))) {
            return TYPE_UNKNOWN; //不明（文字列）
        } else if (string.equals(STRING_NONE)) {
            return TYPE_NONE; //なし（文字列）
        }
        return -1;
    }
}