/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.bean;

import java.util.Locale;

import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * 実行状態の定数クラス<BR>
 * 
 * @version 1.0.0
 * 
 */
public class StatusConstant {
    /** 待機(状態の種別) */
    public static final int TYPE_WAIT = 0;

    /** 保留中(状態の種別) */
    public static final int TYPE_RESERVING = 1;

    /** スキップ(状態の種別) */
    public static final int TYPE_SKIP = 2;

    /** 実行中(状態の種別) */
    public static final int TYPE_RUNNING = 100;

    /** 停止処理中(状態の種別) */
    public static final int TYPE_STOPPING = 101;

    /** 中断(状態の種別) */
    public static final int TYPE_SUSPEND = 200;

    /** コマンド停止(状態の種別) */
    public static final int TYPE_STOP = 201;

    /** 終了(状態の種別) */
    public static final int TYPE_END = 300;

    /** 変更済(状態の種別) */
    public static final int TYPE_MODIFIED = 301;

    /** 起動失敗(状態の種別) */
    public static final int TYPE_ERROR = 400;

    /**
     * 種別から文字列に変換する
     * 
     * @param type
     * @return
     */
    public static String typeToString(int type, Locale locale) {
        if (type == TYPE_RUNNING) {
            return WebMessages.getString("running", locale);    //実行中(状態の種別)
        } else if (type == TYPE_END) {
            return WebMessages.getString("end", locale);        //終了(状態の種別)
        } else if (type == TYPE_WAIT) {
            return WebMessages.getString("wait", locale);       //待機(状態の種別)
        } else if (type == TYPE_STOPPING) {
            return WebMessages.getString("stopping", locale);   //停止処理中(状態の種別)
        } else if (type == TYPE_STOP) {
            return WebMessages.getString("stop.at.once", locale);   //コマンド停止(状態の種別)
        } else if (type == TYPE_RESERVING) {
            return WebMessages.getString("reserving", locale);      //保留中(状態の種別)
        } else if (type == TYPE_MODIFIED) {
            return WebMessages.getString("modified", locale);       //変更済(状態の種別)
        } else if (type == TYPE_ERROR) {
            return WebMessages.getString("start.error", locale);    //起動失敗(状態の種別)
        } else if (type == TYPE_SKIP) {
            return WebMessages.getString("skip", locale);           //スキップ(状態の種別)
        } else if (type == TYPE_SUSPEND) {
            return WebMessages.getString("suspend", locale);        //中断(状態の種別)
        }
        return "";
    }

    /**
     * 文字列から種別に変換する
     * 
     * @param type
     * @return
     */
    public static int stringToType(String string) {
        if ((string.equals(WebMessages.getString("running", Locale.JAPAN))) 
                || (string.equals(WebMessages.getString("running", Locale.ENGLISH)))){
            return TYPE_RUNNING;        //実行中(状態の種別)
        } else if ((string.equals(WebMessages.getString("end", Locale.JAPAN)))
                || (string.equals(WebMessages.getString("end", Locale.ENGLISH)))){
            return TYPE_END;            //終了(状態の種別)
        } else if ((string.equals(WebMessages.getString("wait", Locale.JAPAN)))
                || (string.equals(WebMessages.getString("wait", Locale.ENGLISH)))){
            return TYPE_WAIT;           //待機(状態の種別)
        } else if ((string.equals(WebMessages.getString("stopping", Locale.JAPAN))) 
                || (string.equals(WebMessages.getString("stopping", Locale.ENGLISH)))) {
            return TYPE_STOPPING;       //停止処理中(状態の種別)
        } else if ((string.equals(WebMessages.getString("stop.at.once", Locale.JAPAN)))
                || (string.equals(WebMessages.getString("stop.at.once", Locale.ENGLISH)))){
            return TYPE_STOP;           //コマンド停止(状態の種別)
        } else if ((string.equals(WebMessages.getString("reserving", Locale.JAPAN))) 
                || (string.equals(WebMessages.getString("reserving", Locale.ENGLISH)))){
            return TYPE_RESERVING;      //保留中(状態の種別)
        } else if ((string.equals(WebMessages.getString("modified", Locale.JAPAN)))
                || (string.equals(WebMessages.getString("modified", Locale.ENGLISH)))){
            return TYPE_MODIFIED;       //変更済(状態の種別)
        } else if ((string.equals(WebMessages.getString("start.error", Locale.JAPAN)))
                || (string.equals(WebMessages.getString("start.error", Locale.ENGLISH)))){
            return TYPE_ERROR;          //起動失敗(状態の種別)
        } else if ((string.equals(WebMessages.getString("skip", Locale.JAPAN)))
                || (string.equals(WebMessages.getString("skip", Locale.ENGLISH)))){
            return TYPE_SKIP;           //スキップ(状態の種別)
        } else if ((string.equals(WebMessages.getString("suspend", Locale.JAPAN)))
                || (string.equals(WebMessages.getString("suspend", Locale.ENGLISH)))){
            return TYPE_SUSPEND;        //中断(状態の種別)
        }
        return -1;
    }
}