/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[ジョブ詳細]ビューのテーブル定義を取得するクライアント側アクションクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobDetailTableDefine {

	/** ツリー */
	public static final int TREE = 0;
	/** 実行状態 */
	public static final int STATUS = 1;
	/** 終了状態 */
	public static final int END_STATUS = 2;
	/** 終了値 */
	public static final int END_VALUE = 3;
	/** ジョブID */
	public static final int JOB_ID = 4;
	/** ジョブ名 */
	public static final int JOB_NAME = 5;
	/** 所属ジョブユニットのジョブID */
	public static final int JOBUNIT_ID = 6;
	/** 種別 */
	public static final int JOB_TYPE = 7;
	/** ファシリティID */
	public static final int FACILITY_ID = 8;
	/** スコープ */
	public static final int SCOPE = 9;
	/** 時刻 */
	public static final int WAIT_RULE_TIME = 10;
	/** 開始・再実行日時 */
	public static final int START_RERUN_TIME = 11;
	/** 終了・中断日時 */
	public static final int END_SUSPEND_TIME = 12;

	/** 初期表示時ソートカラム */
	public static final int SORT_COLUMN_INDEX = JOB_ID;
	/** 初期表示時ソートオーダー (昇順=1, 降順=-1) */
	public static final int SORT_ORDER = 1;

	/**
	 * ジョブ[ジョブ詳細]ビューのテーブル定義を取得する
	 * 
	 * @return テーブル定義情報
	 */
	public static ArrayList<TableColumnInfoJs> get(Locale locale) {
	    /** テーブル定義配列*/
		ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

		/** メイン処理 */
		tableDefine.add(TREE, new TableColumnInfoJs(
		        "", TableColumnInfoJs.NONE, 30, SWT.LEFT,
                JobMappingUtil.getJobDetailName(TREE), false));
		tableDefine.add(STATUS, new TableColumnInfoJs(
		        WebMessages.getString("run.status", locale), 
		        TableColumnInfoJs.STATE, 60, SWT.LEFT,
                JobMappingUtil.getJobDetailName(STATUS), false));
		tableDefine.add(END_STATUS, new TableColumnInfoJs(
		        WebMessages.getString("end.status", locale), 
		        TableColumnInfoJs.END_STATUS, 60, SWT.LEFT,
                JobMappingUtil.getJobDetailName(END_STATUS), false));
		tableDefine.add(END_VALUE, new TableColumnInfoJs(
		        WebMessages.getString("end.value", locale), 
		        TableColumnInfoJs.NONE, 50, SWT.LEFT,
                JobMappingUtil.getJobDetailName(END_VALUE), false));
		tableDefine.add(JOB_ID, new TableColumnInfoJs(
		        WebMessages.getString("job.id", locale),
		        TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getJobDetailName(JOB_ID), false));
		tableDefine.add(JOB_NAME, new TableColumnInfoJs(
		        WebMessages.getString("job.name", locale), 
		        TableColumnInfoJs.NONE, 150, SWT.LEFT,
                JobMappingUtil.getJobDetailName(JOB_NAME), false));
		tableDefine.add(JOBUNIT_ID, new TableColumnInfoJs(
		        WebMessages.getString("jobunit.id", locale), 
		        TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getJobDetailName(JOBUNIT_ID), false));
		tableDefine.add(JOB_TYPE, new TableColumnInfoJs(
		        WebMessages.getString("type", locale), 
		        TableColumnInfoJs.JOB, 110, SWT.LEFT,
                JobMappingUtil.getJobDetailName(JOB_TYPE), false));
		tableDefine.add(FACILITY_ID, new TableColumnInfoJs(
		        WebMessages.getString("facility.id", locale),
		        TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getJobDetailName(FACILITY_ID), false));
		tableDefine.add(SCOPE, new TableColumnInfoJs(
		        WebMessages.getString("scope", locale),
		        TableColumnInfoJs.FACILITY, 150, SWT.LEFT,
                JobMappingUtil.getJobDetailName(SCOPE), false));
		tableDefine.add(WAIT_RULE_TIME, new TableColumnInfoJs(
		        WebMessages.getString("wait.rule.time", locale), 
		        TableColumnInfoJs.NONE, 120, SWT.LEFT,
                JobMappingUtil.getJobDetailName(WAIT_RULE_TIME), false));
		tableDefine.add(START_RERUN_TIME, new TableColumnInfoJs(
		        WebMessages.getString("start.rerun.time", locale), 
		        TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getJobDetailName(START_RERUN_TIME), false));
		tableDefine.add(END_SUSPEND_TIME, new TableColumnInfoJs(
		        WebMessages.getString("end.suspend.time", locale), 
		        TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getJobDetailName(END_SUSPEND_TIME), false));

		return tableDefine;
	}
}