/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobMappingUtil;
import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブ[ノード詳細]ビューのテーブル定義を取得するクライアント側アクションクラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeDetailTableDefine {

    /** 実行状態 */
    public static final int STATUS = 0;
    /** 戻り値 */
    public static final int RETURN_VALUE = 1;
    /** ファシリティID */
    public static final int FACILITY_ID = 2;
    /** ファシリティ名 */
    public static final int FACILITY_NAME = 3;
    /** 開始・再実行日時 */
    public static final int START_RERUN_TIME = 4;
    /** 終了・中断日時 */
    public static final int END_SUSPEND_TIME = 5;
    /** メッセージ */
    public static final int MESSAGE = 6;

    /** 初期表示時ソートカラム */
    public static final int SORT_COLUMN_INDEX = FACILITY_ID;
    /** 初期表示時ソートオーダー (昇順=1, 降順=-1) */
    public static final int SORT_ORDER = 1;

    /**
     * マネージャにSessionBean経由でアクセスし、
     * ジョブ[ノード詳細]ビューのテーブル定義を取得する
     * 
     * @return テーブル定義情報
     */
    public static ArrayList<TableColumnInfoJs> get(Locale locale) {
        //テーブル定義配列
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();
        
        tableDefine.add(STATUS, new TableColumnInfoJs(
                WebMessages.getString("run.status", locale), 
                TableColumnInfoJs.STATE, 60, SWT.LEFT,
                JobMappingUtil.getJobNodeDetailName(STATUS)));
        tableDefine.add(RETURN_VALUE, new TableColumnInfoJs(
                WebMessages.getString("return.value", locale), 
                TableColumnInfoJs.NONE, 50, SWT.LEFT,
                JobMappingUtil.getJobNodeDetailName(RETURN_VALUE)));
        tableDefine.add(FACILITY_ID, new TableColumnInfoJs(
                WebMessages.getString("facility.id", locale), 
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                JobMappingUtil.getJobNodeDetailName(FACILITY_ID)));
        tableDefine.add(FACILITY_NAME, new TableColumnInfoJs(
                WebMessages.getString("facility.name", locale), 
                TableColumnInfoJs.FACILITY, 150, SWT.LEFT,
                JobMappingUtil.getJobNodeDetailName(FACILITY_NAME)));
        tableDefine.add(START_RERUN_TIME, new TableColumnInfoJs(
                WebMessages.getString("start.rerun.time", locale), 
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getJobNodeDetailName(START_RERUN_TIME)));
        tableDefine.add(END_SUSPEND_TIME, new TableColumnInfoJs(
                WebMessages.getString("end.suspend.time", locale), 
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                JobMappingUtil.getJobNodeDetailName(END_SUSPEND_TIME)));
        tableDefine.add(MESSAGE, new TableColumnInfoJs(
                WebMessages.getString("message", locale), 
                TableColumnInfoJs.TEXT_DIALOG, 300, SWT.LEFT,
                JobMappingUtil.getJobNodeDetailName(MESSAGE)));

        return tableDefine;
    }
}