/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;

import com.necsoft.hinemos.webclient.bean.TreeInfo;

/**
 * ファシリティ情報定義するクラス
 * 
 **/
public class JobTreeBean extends TreeInfo implements Serializable {

    /**
	 * 
	 */
    private static final long serialVersionUID = -4354544925806741380L;

    private String jobId;

    private String jobunitId;

    private String path;

    private Map<String, Object> jobData;

    private ArrayList<JobTreeBean> children;

    public JobTreeBean() {
        children = new ArrayList<JobTreeBean>();
    }

    public void addChildren(JobTreeBean child) {
        children.add(child);
    }

    /**
     * @return the jobId
     */
    public String getJobId() {
        return jobId;
    }

    /**
     * @param jobId
     *            the jobId to set
     */
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    /**
     * @return the jobunitId
     */
    public String getJobunitId() {
        return jobunitId;
    }

    /**
     * @param jobunitId
     *            the jobunitId to set
     */
    public void setJobunitId(String jobunitId) {
        this.jobunitId = jobunitId;
    }

    /**
     * @return the path
     */
    public String getPath() {
        return path;
    }

    public Map<String, Object> getJobData() {
        return jobData;
    }

    public void setJobData(Map<String, Object> jobData) {
        this.jobData = jobData;
    }

    /**
     * @param path
     *            the path to set
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * @return the children
     */
    public ArrayList<JobTreeBean> getChildren() {
        return children;
    }

    /**
     * @param children
     *            the children to set
     */
    public void setChildren(ArrayList<JobTreeBean> children) {
        this.children = children;
    }

}
