/*

Copyright (C) NEC Corporation 2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package com.necsoft.hinemos.webclient.jobmanagement.bean;

import java.util.Locale;

import com.necsoft.hinemos.webclient.lang.WebMessages;

/**
 * ジョブの操作種別を定数として定義するクラス<BR>
 */
public class OperationConstant {

    /** ジョブの操作 */
    public static final String JOB_CONTROL_START = "start";

    public static final String JOB_CONTROL_STOP = "stop";

    /** 開始[即時] */
    public static final int TYPE_START_AT_ONCE = 1;

    /** 開始[中断解除] */
    public static final int TYPE_START_SUSPEND = 3;

    /** 開始[スキップ解除] */
    public static final int TYPE_START_SKIP = 5;

    /** 開始[保留解除] */
    public static final int TYPE_START_WAIT = 7;

    /** 停止[コマンド] */
    public static final int TYPE_STOP_AT_ONCE = 0;

    /** 停止[中断] */
    public static final int TYPE_STOP_SUSPEND = 2;

    /** 停止[スキップ] */
    public static final int TYPE_STOP_SKIP = 4;

    /** 停止[保留] */
    public static final int TYPE_STOP_WAIT = 6;

    /** 停止[終了値の変更] */
    public static final int TYPE_STOP_MAINTENANCE = 8;

    /** 停止[終了値の指定] */
    public static final int TYPE_STOP_SET_END_VALUE = 10;

    /** 停止[強制] */
    public static final int TYPE_STOP_FORCE = 11;

    /** 開始[即時] */
    private static final String STRING_START_AT_ONCE_JP = WebMessages
            .getString("job.start.at.once", Locale.JAPAN);

    private static final String STRING_START_AT_ONCE_EN = WebMessages
            .getString("job.start.at.once", Locale.ENGLISH);

    /** 開始[中断解除] */
    private static final String STRING_START_SUSPEND_JP = WebMessages
            .getString("job.start.release.suspend", Locale.JAPAN);

    private static final String STRING_START_SUSPEND_EN = WebMessages
            .getString("job.start.release.suspend", Locale.ENGLISH);

    /** 開始[スキップ解除] */
    private static final String STRING_START_SKIP_JP = WebMessages.getString(
            "job.start.release.skip", Locale.JAPAN);

    private static final String STRING_START_SKIP_EN = WebMessages.getString(
            "job.start.release.skip", Locale.ENGLISH);

    /** 開始[保留解除] */
    private static final String STRING_START_WAIT_JP = WebMessages.getString(
            "job.start.release.reserve", Locale.JAPAN);

    private static final String STRING_START_WAIT_EN = WebMessages.getString(
            "job.start.release.reserve", Locale.ENGLISH);

    /** 停止[コマンド] */
    private static final String STRING_STOP_AT_ONCE_JP = WebMessages.getString(
            "job.stop.at.once", Locale.JAPAN);

    private static final String STRING_STOP_AT_ONCE_EN = WebMessages.getString(
            "job.stop.at.once", Locale.ENGLISH);

    /** 停止[中断] */
    private static final String STRING_STOP_SUSPEND_JP = WebMessages.getString(
            "job.stop.suspend", Locale.JAPAN);

    private static final String STRING_STOP_SUSPEND_EN = WebMessages.getString(
            "job.stop.suspend", Locale.ENGLISH);

    /** 停止[スキップ] */
    private static final String STRING_STOP_SKIP_JP = WebMessages.getString(
            "job.stop.skip", Locale.JAPAN);

    private static final String STRING_STOP_SKIP_EN = WebMessages.getString(
            "job.stop.skip", Locale.ENGLISH);

    /** 停止[保留] */
    private static final String STRING_STOP_WAIT_JP = WebMessages.getString(
            "job.stop.reserve", Locale.JAPAN);

    private static final String STRING_STOP_WAIT_EN = WebMessages.getString(
            "job.stop.reserve", Locale.ENGLISH);

    /** 停止[終了値の変更] */
    private static final String STRING_STOP_MAINTENANCE_JP = WebMessages
            .getString("job.stop.maintenance", Locale.JAPAN);

    private static final String STRING_STOP_MAINTENANCE_EN = WebMessages
            .getString("job.stop.maintenance", Locale.ENGLISH);

    /** 停止[終了値の指定] */
    private static final String STRING_STOP_SET_END_VALUE_JP = WebMessages
            .getString("job.stop.set.end.value", Locale.JAPAN);

    private static final String STRING_STOP_SET_END_VALUE_EN = WebMessages
            .getString("job.stop.set.end.value", Locale.ENGLISH);

    /** 停止[強制] */
    private static final String STRING_STOP_FORCE_JP = WebMessages.getString(
            "job.stop.force", Locale.JAPAN);

    private static final String STRING_STOP_FORCE_EN = WebMessages.getString(
            "job.stop.force", Locale.ENGLISH);

    /**
     * 種別から文字列に変換する。<BR>
     * 
     * @param type
     *            種別
     * @return 文字列
     */
    public static String typeToString(int type, Locale locale) {
        if (locale == null) {
            locale = Locale.JAPAN;
        }

        if (type == TYPE_START_AT_ONCE) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return STRING_START_AT_ONCE_EN;
            } else {
                return STRING_START_AT_ONCE_JP;
            }
        } else if (type == TYPE_START_SUSPEND) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return STRING_START_SUSPEND_EN;
            } else {
                return STRING_START_SUSPEND_JP;
            }
        } else if (type == TYPE_START_SKIP) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return STRING_START_SKIP_EN;
            } else {
                return STRING_START_SKIP_JP;
            }
        } else if (type == TYPE_START_WAIT) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return STRING_START_WAIT_EN;
            } else {
                return STRING_START_WAIT_JP;
            }
        } else if (type == TYPE_STOP_AT_ONCE) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return STRING_STOP_AT_ONCE_EN;
            } else {
                return STRING_STOP_AT_ONCE_JP;
            }
        } else if (type == TYPE_STOP_SUSPEND) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return STRING_STOP_SUSPEND_EN;
            } else {
                return STRING_STOP_SUSPEND_JP;
            }
        } else if (type == TYPE_STOP_SKIP) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return STRING_STOP_SKIP_EN;
            } else {
                return STRING_STOP_SKIP_JP;
            }
        } else if (type == TYPE_STOP_WAIT) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return STRING_STOP_WAIT_EN;
            } else {
                return STRING_STOP_WAIT_JP;
            }
        } else if (type == TYPE_STOP_MAINTENANCE) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return STRING_STOP_MAINTENANCE_EN;
            } else {
                return STRING_STOP_MAINTENANCE_JP;
            }
        } else if (type == TYPE_STOP_SET_END_VALUE) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return STRING_STOP_SET_END_VALUE_EN;
            } else {
                return STRING_STOP_SET_END_VALUE_JP;
            }
        } else if (type == TYPE_STOP_FORCE) {
            if (Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                return STRING_STOP_FORCE_EN;
            } else {
                return STRING_STOP_FORCE_JP;
            }
        }
        return "";
    }

    /**
     * 文字列から種別に変換する。<BR>
     * 
     * @param string
     *            文字列
     * @return 種別
     */
    public static int stringToType(String string) {
        if (string == null) {
            return -1;
        }

        if (string.equals(STRING_START_AT_ONCE_EN)
                || string.equals(STRING_START_AT_ONCE_JP)) {
            return TYPE_START_AT_ONCE;
        } else if (string.equals(STRING_START_SUSPEND_EN)
                || string.equals(STRING_START_SUSPEND_JP)) {
            return TYPE_START_SUSPEND;
        } else if (string.equals(STRING_START_SKIP_EN)
                || string.equals(STRING_START_SKIP_JP)) {
            return TYPE_START_SKIP;
        } else if (string.equals(STRING_START_WAIT_EN)
                || string.equals(STRING_START_WAIT_JP)) {
            return TYPE_START_WAIT;
        } else if (string.equals(STRING_STOP_AT_ONCE_EN)
                || string.equals(STRING_STOP_AT_ONCE_JP)) {
            return TYPE_STOP_AT_ONCE;
        } else if (string.equals(STRING_STOP_SUSPEND_EN)
                || string.equals(STRING_STOP_SUSPEND_JP)) {
            return TYPE_STOP_SUSPEND;
        } else if (string.equals(STRING_STOP_SKIP_EN)
                || string.equals(STRING_STOP_SKIP_JP)) {
            return TYPE_STOP_SKIP;
        } else if (string.equals(STRING_STOP_WAIT_EN)
                || string.equals(STRING_STOP_WAIT_JP)) {
            return TYPE_STOP_WAIT;
        } else if (string.equals(STRING_STOP_MAINTENANCE_EN)
                || string.equals(STRING_STOP_MAINTENANCE_JP)) {
            return TYPE_STOP_MAINTENANCE;
        } else if (string.equals(STRING_STOP_SET_END_VALUE_EN)
                || string.equals(STRING_STOP_SET_END_VALUE_JP)) {
            return TYPE_STOP_SET_END_VALUE;
        } else if (string.equals(STRING_STOP_FORCE_EN)
                || string.equals(STRING_STOP_FORCE_JP)) {
            return TYPE_STOP_FORCE;
        }
        return -1;
    }
}
