/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;

import javax.xml.ws.WebServiceException;

import com.clustercontrol.ws.jobmanagement.HinemosUnknown_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.InvalidUserPass_Exception;
import com.clustercontrol.ws.jobmanagement.JobInfoNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.JobMasterNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.form.JobDetailForm;
import com.necsoft.hinemos.webclient.jobmanagement.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This class used for get header list
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetJobDetailBusiness {
    
    /**
     * ジョブ[ジョブ詳細]情報一覧データを取得
     */
    public ArrayList<ArrayList<Object>> getJobDetail(JobDetailForm form,
            EndpointManager endpointManager) throws HinemosWebException {
        
        ArrayList<ArrayList<Object>> listInfoData = new ArrayList<ArrayList<Object>>();
        JobTreeItem item = null;
        if (form.getSessionId() != null && form.getSessionId().length() > 0) {
            // ジョブ詳細情報取得            
            try {
                item = JobEndpointWrapper.getJobDetailList(form.getSessionId(), endpointManager);
            } catch (InvalidRole_Exception e) {
                // アクセス権なしの場合
                throw new HinemosWebAccessException("exception.data.access");
            } catch (InvalidUserPass_Exception e) {
                // アクセス権なしの場合
                throw new HinemosWebAccessException("exception.data.access");
            } catch (HinemosUnknown_Exception e) {
                // データ一覧の取得に失敗しました
                throw new HinemosWebException("exception.data.action");
            } catch (JobInfoNotFound_Exception e) {
                 // データ一覧の取得に失敗しました
                throw new HinemosWebException("exception.data.action");
            } catch (JobMasterNotFound_Exception e) {
                // データ一覧の取得に失敗しました
                throw new HinemosWebException("exception.data.action");
            } catch (WebServiceException e) {
                // Hinemosマネージャより応答がありませんでした。ログアウトします。
                throw new HinemosWebException("message.force.disconnect");
            }
        }
        //リストに変換する
        ConvertListUtil.generateSerializedData(listInfoData, item.getChildren(), 
                JsConstant.TREEGRID_ROOT_LEVEL, JsConstant.TREEGRID_ROOT_PARENT);
        
        //Sanitize
        ConvertListUtil.sanitizeJobDetailList(listInfoData);
         
        return listInfoData;        
    }
}