/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.ArrayList;
import java.util.Locale;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebHeaderInvalidException;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetJobTableDefine;

/**
 * This class used for get header list
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobTableDefineBusiness {

    /**
     * Get header list
     * 
     * @return ArrayList<TableColumnInfoJs>
     * @throws HinemosWebException
     */
    public ArrayList<TableColumnInfoJs> getJobTableDefine(Locale locale)
            throws HinemosWebException {
        // 中間変数を宣言
        ArrayList<TableColumnInfoJs> tblDefine = null;

        // テーブルヘッダ定義データ(JobTableDefine)を取得
        tblDefine = GetJobTableDefine.get(locale);

        // テーブルヘッダ定義データの項目数チェック
        if (tblDefine.size() != JobManagementConstants.JOB_LIST_HEADER_NUM) {
            // 項目数が不足の場合
            throw new HinemosWebHeaderInvalidException("exception.header.number");
        }

        return tblDefine;
    }
}