/*
 
Copyright (C) NEC Corporation 2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.necsoft.hinemos.webclient.jobmanagement.business;

import java.util.Locale;

import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.form.OperationForm;
import com.necsoft.hinemos.webclient.jobmanagement.util.OperationJobProperty;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * This class is used for get Operation property
 **/
public class GetOperationJobPropertyBusiness {

    /**
     * Get Operation property
     * 
     * @return Property
     * @throws HinemosWebException
     */
    public Property getOperationProperty(OperationForm form, Locale locale,
            EndpointManager endpointManager) throws HinemosWebException {

        // 中間変数を宣言
        Property property = null;

        // DTOをプロパティに変換する
        property = OperationJobProperty.getProperty(form, locale,
                endpointManager);
        if (property == null) {
            // オペレーション情報一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        }
        return property;
    }
}