/*
 
Copyright (C) NEC Corporation 2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.business;

import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;
import com.clustercontrol.ws.jobmanagement.JobMasterNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.JobTriggerInfo;
import com.necsoft.hinemos.webclient.bean.JobTriggerTypeConstant;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebJobInfoNotFoundException;
import com.necsoft.hinemos.webclient.jobmanagement.util.JobEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * ジョブ[一覧]に選択したジョブを実行するビジネスクラス
 */
public class RunJobBusiness {

    public void runJob(String jobunitId, String jobId, EndpointManager endpointManager) 
        throws HinemosWebException {
        try {
            // 実行契機情報を登録
            JobTriggerInfo triggerInfo = new JobTriggerInfo();
            triggerInfo.setTriggerType(JobTriggerTypeConstant.TYPE_MANUAL);

            // ジョブ実行
            JobEndpointWrapper.runJob(
                    jobunitId,
                    jobId,
                    null,
                    triggerInfo,
                    endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("message.accesscontrol.16");
        } catch (JobMasterNotFound_Exception e) {
            // Hinemosマネージャ内で予期せぬ内部エラーが発生しました
            throw new HinemosWebJobInfoNotFoundException("message.hinemos.failure.unexpected.jodid.notfound");
        } catch (Exception e) {
            // Hinemosマネージャ内で予期せぬ内部エラーが発生しました
            throw new HinemosWebException("message.hinemos.failure.unexpected");
        }        
    }
}

