/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.json;

import java.util.ArrayList;

import com.necsoft.hinemos.webclient.jobmanagement.bean.JobTreeBean;
import com.necsoft.hinemos.webclient.json.CommonJson;

/**
 * Template for generator FacilityTree JSON
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobTreeJson extends CommonJson {
    private ArrayList<JobTreeBean> jobTree;

    public JobTreeJson() {
        this.jobTree = new ArrayList<JobTreeBean>();
    }

    // Facility getter
    public ArrayList<JobTreeBean> getJobTree() {
        return jobTree;
    }

    // Facility getter
    public void setJobTree(ArrayList<JobTreeBean> jobTree) {
        this.jobTree = jobTree;
    }

    // Add a FacilityTreeBean to list
    public void addJobTree(JobTreeBean jobTree) {
        this.jobTree.add(jobTree);
    }
}