/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetForwardFileTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetForwardFileTableDefineBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for get header list
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetForwardFileTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -6712416036223172058L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetForwardFileTableDefineServlet.class);

    /**
     * Get header list
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
        
        // 中間変数を宣言
        CommonJson result = new CommonJson();

        try {
            GetForwardFileTableDefineBusiness business 
                = new GetForwardFileTableDefineBusiness();
            
            ArrayList<TableColumnInfoJs> tblDefine 
                = business.getForwardFileTableDefine(request.getLocale());

            setModelProperties(tblDefine);

            //Convert header to JSON structure
            result = DataProcess.doConvertTableDefineToJson(
                    tblDefine, true, request.getLocale(),
                    JobManagementConstants.ROW_NUM,
                    GetForwardFileTableDefine.SORT_COLUMN_INDEX,
                    GetForwardFileTableDefine.SORT_ORDER);

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    /**
     * @param tblDefine
     */
    private void setModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        tblDefine.get(GetForwardFileTableDefine.STATUS).setFormatter(
                JsConstant.GRID_FMATTER_RUN_STATUS);

        tblDefine.get(GetForwardFileTableDefine.END_STATUS).setFormatter(
                JsConstant.GRID_FMATTER_END_STATUS);

        tblDefine.get(GetForwardFileTableDefine.START_RERUN_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);

        tblDefine.get(GetForwardFileTableDefine.END_SUSPEND_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);
    }
}