/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.Constants;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetHistoryFilterPropertyBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for get History Property
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetHistoryFilterPropertyServlet extends CommonServlet {
    
    private static final long serialVersionUID = -3131350422822624183L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetHistoryFilterPropertyServlet.class);

    /**
     * Get History Property
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     */
    public CommonJson process(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {

        CommonJson result = new CommonJson();

        try {
            //Get data
            Property propertyHistory = doLoadProperty(request);
          
            //Convert data to JSON structure
            result = DataProcess.doConvertFilterToJson(propertyHistory);

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    /**
     * Get History Property
     * 
     * @param request
     *            : HttpServletRequest
     * @return Property
     * @throws HinemosWebException
     */

    private Property doLoadProperty(HttpServletRequest request) throws HinemosWebException {
        // 中間変数を宣言
        HttpSession session = request.getSession(true);
        Property propertyHistory = (Property) session.
                getAttribute(Constants.HISTORY_FILTER_PROPERTIES);
        String lang = (String)session.
                getAttribute(Constants.HISTORY_FILTER_PROPERTIES_LANG);
        String cur_lang = request.getLocale().getLanguage();
        // イベント情報一覧を取得
        if ((propertyHistory == null) || !(cur_lang.equals(lang))) {
            GetHistoryFilterPropertyBusiness business = new GetHistoryFilterPropertyBusiness();
            propertyHistory = business.getHistoryFilterProperty(request.getLocale());
            session.setAttribute(Constants.HISTORY_FILTER_PROPERTIES,
                    propertyHistory);
            session.setAttribute(Constants.HISTORY_FILTER_PROPERTIES_LANG,
                    cur_lang);
        }
         return propertyHistory;
     }
}