/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.jobmanagement.JobManagementConstants;
import com.necsoft.hinemos.webclient.jobmanagement.action.GetNodeDetailTableDefine;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetNodeDetailTableDefineBusiness;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;

/**
 * This class used for get header list
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodeDetailTableDefineServlet extends CommonServlet {

    private static final long serialVersionUID = -6712416036223172058L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetNodeDetailTableDefineServlet.class);

    /**
     * Get header list
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        CommonJson result = new CommonJson();
        GetNodeDetailTableDefineBusiness business = null;
        
        try {
            // get data
            business = new GetNodeDetailTableDefineBusiness();
            ArrayList<TableColumnInfoJs> tblDefine = business.
                                        getNodeDetailTableDefine(request.getLocale());

            // set property
            setModelProperties(tblDefine);

            // convert to Json
            result = DataProcess.doConvertTableDefineToJson(
                    tblDefine, true, request.getLocale(), 
                    JobManagementConstants.ROW_NUM,
                    GetNodeDetailTableDefine.SORT_COLUMN_INDEX,
                    GetNodeDetailTableDefine.SORT_ORDER);

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), request.getLocale());
        }
        return result;
    }

    /**
     * @param tblDefine
     */
    private void setModelProperties(ArrayList<TableColumnInfoJs> tblDefine) {
        tblDefine.get(GetNodeDetailTableDefine.STATUS).setFormatter(
                JsConstant.GRID_FMATTER_RUN_STATUS);

        TableColumnInfoJs facilityName = tblDefine
                .get(GetNodeDetailTableDefine.FACILITY_NAME);
        facilityName.setFormatter(JsConstant.GRID_FMATTER_SCOPE_TYPE);
        Map<String, Object> scopeFmtOpt = new HashMap<String, Object>();
        scopeFmtOpt.put(JsConstant.GRID_FMATTER_SCOPE_TYPE_POSITION,
                GetNodeDetailTableDefine.FACILITY_ID);
        facilityName.setFormatoptions(scopeFmtOpt);

        tblDefine.get(GetNodeDetailTableDefine.START_RERUN_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);

        tblDefine.get(GetNodeDetailTableDefine.END_SUSPEND_TIME).setFormatter(
                JsConstant.GRID_FMATTER_DATE_TIME);

        tblDefine.get(GetNodeDetailTableDefine.MESSAGE).setFormatter(
                JsConstant.GRID_FMATTER_MSG_BTN);
    }
}