/*
 
Copyright (C) NEC Corporation 2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.bean.OperationConstant;
import com.necsoft.hinemos.webclient.jobmanagement.business.GetOperationJobPropertyBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.form.OperationForm;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class is used for get Operation Property
 **/
public class GetOperationJobPropertyServlet extends CommonServlet {

    private static final long serialVersionUID = 8999944607615025169L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetHistoryFilterPropertyServlet.class);

    /**
     * Get Operation Job Property
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        Locale locale = request.getLocale();
        if (!(Locale.ENGLISH.getLanguage().equals(locale.getLanguage()))) {
            locale = Locale.JAPAN;
        }

        CommonJson result = new CommonJson();

        try {
            // 中間変数を宣言
            Property property = doLoadProperty(request);

            // JSONに変換
            result = DataProcess.doConvertOperationInfoToJson(property);

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_INFO, 
                    ex.getMessage(),
                    request.getLocale());
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage(),
                    locale);

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), locale);
        }
        return result;
    }

    private Property doLoadProperty(HttpServletRequest request)
            throws HinemosWebException {
        // 中間変数を宣言
        Property property = null;
        OperationForm form = new OperationForm();
        PopulateBeanUtils.populateBean(form, request);
        if (!isValidRequestParam(form)) {
            // 対象の設定情報が不正です
            throw new HinemosWebException("exception.data.param");
        }
        Locale locale = request.getLocale();
        if (!(Locale.ENGLISH.getLanguage().equals(locale.getLanguage()))) {
            locale = Locale.JAPAN;
        }
        // loginManagerのsessionを取得
        HttpSession session = request.getSession(true);
        LoginManager loginManager = null;
        synchronized (session) {
            loginManager = (LoginManager) session
                    .getAttribute(AccessControlConstants.LOGIN_MANAGER);

            GetOperationJobPropertyBusiness business = 
                                        new GetOperationJobPropertyBusiness();
            // ビジネスからオペレーション操作用プロパティを取得
            property = business.getOperationProperty(form, locale,
                    loginManager.endpointManager);
        }

        return property;
    }

    private boolean isValidRequestParam(OperationForm form) {
        boolean isValid = true;
        String control = form.getControl();
        if (form.getSessionId() == null
                || "".equalsIgnoreCase(form.getSessionId().trim())
                || form.getJobunitId() == null
                || "".equalsIgnoreCase(form.getJobunitId().trim())
                || form.getJobId() == null
                || "".equalsIgnoreCase(form.getJobId().trim())
                || control == null
                || !(control.equals(OperationConstant.JOB_CONTROL_START)
                       || control.equals(OperationConstant.JOB_CONTROL_STOP))) {
            isValid = false;
        }
        return isValid;
    }
}
