/*
 
Copyright (C) NEC Corporation 2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.necsoft.hinemos.webclient.jobmanagement.servlet;

import java.io.IOException;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.clustercontrol.ws.jobmanagement.NodeOperationInfo;
import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.jobmanagement.bean.OperationConstant;
import com.necsoft.hinemos.webclient.jobmanagement.business.OperationJobBusiness;
import com.necsoft.hinemos.webclient.jobmanagement.form.OperationForm;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class is used for operating with job
 **/
public class OperationJobServlet extends CommonServlet {

    private static final long serialVersionUID = 4605228304772729403L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetScheduleServlet.class);

    /**
     * Operation job
     * 
     * @param request
     *            : HttpServletRequest
     * @param response
     *            : HttpServletResponse
     * @throws ServletException
     * @throws IOException
     * @throws HinemosWebAccessException
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();

        Locale locale = request.getLocale();
        if (!(Locale.ENGLISH.getLanguage().equals(locale.getLanguage()))) {
            locale = Locale.JAPAN;
        }

        try {
            doOperationJob(request);

        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_INFO, 
                    ex.getMessage(),
                    request.getLocale());
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage(),
                    locale);
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(), locale);
        }
        return result;
    }

    /**
     * ジョブオペレーションを行
     */
    private void doOperationJob(HttpServletRequest request)
            throws HinemosWebException {
        // 中間変数を宣言
        OperationForm form = new OperationForm();
        NodeOperationInfo info = new NodeOperationInfo();
        
        PopulateBeanUtils.populateBean(form, request);
        if (!isValidRequestParam(form)) {
            // 対象の設定情報が不正です
            throw new HinemosWebException("exception.data.param");
        }
        info.setSessionId(form.getSessionId());
        info.setJobunitId(form.getJobunitId());
        info.setJobId(form.getJobId());
        info.setFacilityId(form.getFacilityId());
        info.setControl(Integer.valueOf(
                OperationConstant.stringToType(form.getControl())));
        info.setEndValue(form.getEndValue());
        
        // Get loginManager session
        HttpSession session = request.getSession(true);
        LoginManager loginManager = null;
        synchronized (session) {
            loginManager = (LoginManager) session
                    .getAttribute(AccessControlConstants.LOGIN_MANAGER);

            OperationJobBusiness business = new OperationJobBusiness();
            business.operationJob(info,
                    loginManager.endpointManager);
        }
        return;
    }

    private boolean isValidRequestParam(OperationForm form) {
        boolean isValid = true;
        if (form.getSessionId() == null
                || "".equalsIgnoreCase(form.getSessionId().trim())
                || form.getJobunitId() == null
                || "".equalsIgnoreCase(form.getJobunitId().trim())
                || form.getJobId() == null
                || "".equalsIgnoreCase(form.getJobId().trim())
                || form.getControl() == null
                || "".equalsIgnoreCase(form.getControl().trim())) {
            isValid = false;
        }
        return isValid;
    }
}