/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class GridDataJson extends CommonJson {

    private int records;

    private ArrayList<JSONObject> rows;

    private Map<String, Object> userdata;

    public GridDataJson() {
        this.records = 0;
        this.rows = new ArrayList<JSONObject>();
        this.userdata = new HashMap<String, Object>();
    }

    public int getRecords() {
        return this.records;
    }

    public void setRecords(int records) {
        this.records = records;
    }

    public ArrayList<JSONObject> getRows() {
        return this.rows;
    }

    public void setRows(ArrayList<JSONObject> rows) {
        this.rows = rows;
    }

    public void addRow(List<Object> data) {
        JSONObject row = new JSONObject();
        this.addRowData(row, data);
    }

    public void addRow(List<Object> data, String value) {
        JSONObject row = new JSONObject();
        row.put("id", value);
        this.addRowData(row, data);
    }

    private void addRowData(JSONObject row, List<Object> data) {
        JSONArray jdata = JSONArray.fromObject(data);
        row.put("cell", jdata);
        this.rows.add(row);
    }

    public Map<String, Object> getUserdata() {
        return this.userdata;
    }

    public void setUserdata(Map<String, Object> userdata) {
        this.userdata = userdata;
    }

    public void addUserdatas(Map<String, Object> map) {
        this.userdata.putAll(map);
    }

    public void addUserdata(String key, Object obj) {
        this.userdata.put(key, obj);
    }
}
