/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.action;

import java.util.ArrayList;
import java.util.Locale;

import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.common.SWT;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.monitor.util.MonitorMappingUtil;

/**
 * 監視[ステータス]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得します。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetStatusListTableDefine {

    /** 重要度。 */
    public static final int PRIORITY = 0;

    /** プラグインID。 */
    public static final int PLUGIN_ID = 1;

    /** 監視項目ID。 */
    public static final int MONITOR_ID = 2;

    /** 監視詳細。 */
    public static final int MONITOR_DETAIL_ID = 3;

    /** ファシリティID。 */
    public static final int FACILITY_ID = 4;

    /** スコープ。 */
    public static final int SCOPE = 5;

    /** アプリケーション。 */
    public static final int APPLICATION = 6;

    /** 更新日時。 */
    public static final int UPDATE_TIME = 7;

    /** 出力日時。 */
    public static final int OUTPUT_TIME = 8;

    /** メッセージID。 */
    public static final int MESSAGE_ID = 9;

    /** メッセージ。 */
    public static final int MESSAGE = 10;

    /** 初期表示時ソートカラム。 */
    public static final int SORT_COLUMN_INDEX = FACILITY_ID;

    /** 初期表示時ソートオーダー。 */
    public static final int SORT_ORDER = 1;

    /**
     * 監視[ステータス]ビューのテーブル定義情報を取得します。<BR><BR>
     * リストに、カラム毎にテーブルカラム情報をセットします。
     * 
     * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
     * 
     * @see com.clustercontrol.bean.TableColumnInfo#TableColumnInfoJs(java.lang.String, int, int, int)
     * @see com.clustercontrol.monitor.bean.StatusTableDefine
     */
    public static ArrayList<TableColumnInfoJs> getStatusListTableDefine(Locale locale) {

        /** テーブル情報定義配列 */
        ArrayList<TableColumnInfoJs> tableDefine = new ArrayList<TableColumnInfoJs>();

        tableDefine.add(PRIORITY, new TableColumnInfoJs(
                WebMessages.getString("priority", locale), 
                TableColumnInfoJs.PRIORITY, 55, SWT.LEFT,
                MonitorMappingUtil.getStatusName(PRIORITY)));
        tableDefine.add(PLUGIN_ID, new TableColumnInfoJs(
                WebMessages.getString("plugin.id", locale), 
                TableColumnInfoJs.NONE, 90, SWT.LEFT,
                MonitorMappingUtil.getStatusName(PLUGIN_ID)));
        tableDefine.add(MONITOR_ID, new TableColumnInfoJs(
                WebMessages.getString("monitor.id", locale), 
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                MonitorMappingUtil.getStatusName(MONITOR_ID)));
        tableDefine.add(MONITOR_DETAIL_ID, new TableColumnInfoJs(
                WebMessages.getString("monitor.detail.id", locale), 
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                MonitorMappingUtil.getStatusName(MONITOR_DETAIL_ID)));
        tableDefine.add(FACILITY_ID, new TableColumnInfoJs(
                WebMessages.getString("facility.id", locale), 
                TableColumnInfoJs.NONE, 100, SWT.LEFT,
                MonitorMappingUtil.getStatusName(FACILITY_ID)));
        tableDefine.add(SCOPE, new TableColumnInfoJs(
                WebMessages.getString("scope", locale), 
                TableColumnInfoJs.FACILITY, 150, SWT.LEFT,
                MonitorMappingUtil.getStatusName(SCOPE)));
        tableDefine.add(APPLICATION, new TableColumnInfoJs(
                WebMessages.getString("application", locale), 
                TableColumnInfoJs.NONE, 120, SWT.LEFT,
                MonitorMappingUtil.getStatusName(APPLICATION)));
        tableDefine.add(UPDATE_TIME, new TableColumnInfoJs(
                WebMessages.getString("update.time", locale), 
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                MonitorMappingUtil.getStatusName(UPDATE_TIME)));
        tableDefine.add(OUTPUT_TIME, new TableColumnInfoJs(
                WebMessages.getString("output.time", locale), 
                TableColumnInfoJs.NONE, 140, SWT.LEFT,
                MonitorMappingUtil.getStatusName(OUTPUT_TIME)));
        tableDefine.add(MESSAGE_ID, new TableColumnInfoJs(
                WebMessages.getString("message.id", locale), 
                TableColumnInfoJs.NONE, 90, SWT.LEFT,
                MonitorMappingUtil.getStatusName(MESSAGE_ID)));
        tableDefine.add(MESSAGE, new TableColumnInfoJs(
                WebMessages.getString("message", locale), 
                TableColumnInfoJs.NONE, 200, SWT.LEFT,
                MonitorMappingUtil.getStatusName(MESSAGE)));

        return tableDefine;
    }

}