/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;

import com.clustercontrol.ws.monitor.FacilityNotFound_Exception;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.ScopeDataInfo;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.monitor.action.GetScopeListTableDefine;
import com.necsoft.hinemos.webclient.monitor.form.MonitorScopeForm;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.monitor.util.MonitorEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

public class GetScopeListBusiness {

    public ArrayList<ArrayList<Object>> getScopeList(MonitorScopeForm form, EndpointManager endpointManager)
            throws HinemosWebException {
        
        // スコープ情報一覧データ(ScopeInfoData)を取得
        ArrayList<ArrayList<Object>> listInfoData = null;
        List<ScopeDataInfo> records = null;
        try {
            records =  MonitorEndpointWrapper.getScopeList(StringEscapeUtils
                    .unescapeHtml4(form.getFacilityId()), true, true, false, endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (MonitorNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (FacilityNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        } 
        
        listInfoData = ConvertListUtil.scopeInfoDataListToArrayList(records);

        doSortListInfoData(form, listInfoData);

        ConvertListUtil.sanitizeScopeInfoData(listInfoData);

        return listInfoData;
    }

    private void doSortListInfoData(MonitorScopeForm form,
            ArrayList<?> listInfoData) {
        // Get sorting parameter
        int sortColumnIndex = GetScopeListTableDefine.SORT_COLUMN_INDEX;
        int sortOrder = GetScopeListTableDefine.SORT_ORDER;
        if (form.getSidx() != null && !("").equals(form.getSidx().trim())) {
            sortColumnIndex = Integer.valueOf(form.getSidx());
        }
        if (form.getSord() != null && !("").equals(form.getSord().trim())) {
            sortOrder = SortOrderUtil.getSerInt(form.getSord());
        }

        // データをソート
        Collections.sort(listInfoData, new CommonTableViewerSorter(
                sortColumnIndex, -1, sortOrder));
    }
}
