/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

import javax.xml.ws.WebServiceException;

import org.apache.commons.lang3.StringEscapeUtils;
import com.clustercontrol.ws.monitor.HinemosUnknown_Exception;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;
import com.clustercontrol.ws.monitor.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorNotFound_Exception;
import com.clustercontrol.ws.monitor.StatusDataInfo;
import com.clustercontrol.ws.monitor.StatusFilterInfo;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.composite.CommonTableViewerSorter;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.monitor.action.GetStatusListTableDefine;
import com.necsoft.hinemos.webclient.monitor.form.MonitorStatusForm;
import com.necsoft.hinemos.webclient.monitor.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.monitor.util.MonitorEndpointWrapper;
import com.necsoft.hinemos.webclient.monitor.util.StatusFilterPropertyUtil;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.PropertyUtil;
import com.necsoft.hinemos.webclient.util.SortOrderUtil;

public class GetStatusListBusiness {

    public ArrayList<ArrayList<Object>> getStatusList(MonitorStatusForm form,
            Property condition, EndpointManager endpointManager, Locale locale) throws HinemosWebException {
        ArrayList<ArrayList<Object>> listStatusData = null;
        if (condition == null) {
            listStatusData = getListStatusData(form, endpointManager);
        } else {
            listStatusData = getListStatusData(form, condition, endpointManager, locale);
        }

        doSortListDataInfo(form, listStatusData);

        ConvertListUtil.sanitizeStatusInfoData(listStatusData);

        return listStatusData;
    }

    private ArrayList<ArrayList<Object>> getListStatusData(
        MonitorStatusForm form, EndpointManager endpointManager)
        throws HinemosWebException {
        
        ArrayList<ArrayList<Object>> listStatusData = null;
        
        // ステータス情報一覧データ(StatusInfoData)を取得
        List<StatusDataInfo> records = null;
        try {
            records = MonitorEndpointWrapper.getStatusList(StringEscapeUtils
                    .unescapeHtml4(form.getFacilityId()), null, endpointManager);
        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (MonitorNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }
        
        listStatusData = ConvertListUtil.statusInfoDataListToArrayList(records);
        
        return listStatusData;
    }

    private ArrayList<ArrayList<Object>> getListStatusData(
        MonitorStatusForm form, Property condition, EndpointManager endpointManager, Locale locale)
        throws HinemosWebException {
        
        ArrayList<ArrayList<Object>> listStatusData = null;
        // ステータス情報一覧データ(StatusInfoData)を取得

        try {
            List<StatusDataInfo> records = null;
            PropertyUtil.deletePropertyDefine(condition);
            StatusFilterInfo filter = StatusFilterPropertyUtil.property2dto(condition, locale);
            records = MonitorEndpointWrapper.getStatusList(StringEscapeUtils
                    .unescapeHtml4(form.getFacilityId()), filter, endpointManager);
            listStatusData = ConvertListUtil.statusInfoDataListToArrayList(records);

        } catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
        } catch (MonitorNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

        return listStatusData;
    }

    private void doSortListDataInfo(MonitorStatusForm form,
            ArrayList<ArrayList<Object>> listInfoData) {
        // Get sorting parameter
        int sortColumnIndex = GetStatusListTableDefine.SORT_COLUMN_INDEX;
        int sortOrder = GetStatusListTableDefine.SORT_ORDER;
        if (form.getSidx() != null && !form.getSidx().trim().equals("")) {
            sortColumnIndex = Integer.valueOf(form.getSidx());
        }
        if (form.getSord() != null && !form.getSord().trim().equals("")) {
            sortOrder = SortOrderUtil.getSerInt(form.getSord());
        }
        // データをソート
        Collections.sort(listInfoData, new CommonTableViewerSorter(
                sortColumnIndex, -1, sortOrder));
    }

}
