/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.business;

import java.util.ArrayList;
import java.util.Locale;

import com.necsoft.hinemos.webclient.bean.TableColumnInfoJs;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebHeaderInvalidException;
import com.necsoft.hinemos.webclient.monitor.MonitorConstants;
import com.necsoft.hinemos.webclient.monitor.action.GetStatusListTableDefine;

public class GetStatusListTableDefineBusiness {

    public ArrayList<TableColumnInfoJs> getStatusListTableDefine(Locale locale)
            throws HinemosWebException {
        // 中間変数を宣言
        ArrayList<TableColumnInfoJs> tblDefine = null;

        // ステータステーブルヘッダー定義データ(StatusTableDefine)を取得
        tblDefine = GetStatusListTableDefine.getStatusListTableDefine(locale);

        // ステータステーブルヘッダー定義データの項目数チェック
        if (tblDefine.size() != MonitorConstants.NUMBER_HEADER_STATUS) {
            // 項目数が不足の場合
            throw new HinemosWebHeaderInvalidException("exception.header.number");
        }
        return tblDefine;
    }
}
