/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.monitor.bean.EventFilterConstant;
import com.clustercontrol.monitor.bean.StatusFilterConstant;
import com.clustercontrol.ws.monitor.EventFilterInfo;
import com.necsoft.hinemos.webclient.bean.ConfirmConstant;
import com.necsoft.hinemos.webclient.bean.PriorityConstant;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.lang.WebMessages;
import com.necsoft.hinemos.webclient.util.PropertyUtil;

public class EventFilterPropertyUtil {
	/**
	 * プロパティをイベント情報フィルタDTOに変換するメソッドです。
	 * 
	 * @param property
	 * @return イベント情報フィルタ
	 */
	public static EventFilterInfo property2dto(Property property, Locale locale){
		EventFilterInfo info = new EventFilterInfo();

		Integer priority = null;
		Timestamp outputFromDate = null;
		Timestamp outputToDate = null;
		Timestamp generationFromDate = null;
		Timestamp generationToDate = null;
		String facilityType = null;
		String application = null;
		String message = null;
		String confirmUser = null;
		String comment = null;
		String commentUser = null;

		ArrayList values = null;

		//重要度取得
		values = PropertyUtil.getPropertyValue(property,
				StatusFilterConstant.PRIORITY);
		if (!"".equals(values.get(0))) {
			int priorityType = PriorityConstant.stringToType((String) values.get(0), locale);
		    if (priorityType != -1) {
				priority = new Integer(priorityType);
				info.setPriority(priority);
			}
		}

		//更新日時（自）取得
		values = PropertyUtil.getPropertyValue(property,
				EventFilterConstant.OUTPUT_FROM_DATE);
		if (values.get(0) instanceof Date) {
			outputFromDate = new Timestamp(((Date) values.get(0)).getTime());
			outputFromDate.setNanos(0);
			info.setOutputDateFrom(outputFromDate.getTime());
		}

		//更新日時（至）取得
		values = PropertyUtil.getPropertyValue(property,
				EventFilterConstant.OUTPUT_TO_DATE);
		if (values.get(0) instanceof Date) {
			outputToDate = new Timestamp(((Date) values.get(0)).getTime());
			outputToDate.setNanos(999999999);
			info.setOutputDateTo(outputToDate.getTime());
		}

		//出力日時（自）取得
		values = PropertyUtil.getPropertyValue(property,
				EventFilterConstant.GENERATION_FROM_DATE);
		if (values.get(0) instanceof Date) {
			generationFromDate = new Timestamp(((Date) values.get(0))
					.getTime());
			generationFromDate.setNanos(0);
			info.setGenerationDateFrom(generationFromDate.getTime());
		}

		//出力日時（至）取得
		values = PropertyUtil.getPropertyValue(property,
				EventFilterConstant.GENERATION_TO_DATE);
		if (values.get(0) instanceof Date) {
			generationToDate = new Timestamp(((Date) values.get(0))
					.getTime());
			generationToDate.setNanos(999999999);
			info.setGenerationDateTo(generationToDate.getTime());
		}

		//対象ファシリティ種別取得
		values = PropertyUtil.getPropertyValue(property,
				StatusFilterConstant.FACILITY_TYPE);
		if (!"".equals(values.get(0))) {
			facilityType = (String) values.get(0);
			info.setFacilityType(facilityType);
		}

		//アプリケーション取得
		values = PropertyUtil.getPropertyValue(property,
				StatusFilterConstant.APPLICATION);
		if (!"".equals(values.get(0))) {
			application = (String) values.get(0);
			info.setApplication(application);
		}

		//メッセージ取得
		values = PropertyUtil.getPropertyValue(property,
				StatusFilterConstant.MESSAGE);
		if (!"".equals(values.get(0))) {
			message = (String) values.get(0);
			info.setMessage(message);
		}

		// 確認有無取得
		values = PropertyUtil.getPropertyValue(property,
				EventFilterConstant.CONFIRMED);
		int confirmFlgType = ConfirmConstant.stringToType((String) values.get(0), locale);
		info.setConfirmFlgType(confirmFlgType);

		// 確認ユーザ
		values = PropertyUtil.getPropertyValue(property,
				EventFilterConstant.CONFIRM_USER);
		if (!"".equals(values.get(0))) {
			confirmUser = (String) values.get(0);
		}
		info.setConfirmedUser(confirmUser);

		// コメント
		values = PropertyUtil.getPropertyValue(property,
				EventFilterConstant.COMMENT);
		if (!"".equals(values.get(0))) {
			comment = (String) values.get(0);
		}
		info.setComment(comment);

		// コメントユーザ
		values = PropertyUtil.getPropertyValue(property,
				EventFilterConstant.COMMENT_USER);
		if (!"".equals(values.get(0))) {
			commentUser = (String) values.get(0);
		}
		info.setCommentUser(commentUser);

		return info;
	}


	/**
	 * イベント情報フィルタ用プロパティを取得します。<BR>
	 * <p>
	 * <ol>
	 *  <li>フィルタ項目毎にID, 名前, 処理定数（{@link com.clustercontrol.bean.PropertyConstant}）を指定し、
	 *      プロパティ（{@link com.clustercontrol.bean.Property}）を生成します。</li>
	 *  <li>各フィルタ項目のプロパティをツリー状に定義します。</li>
	 * </ol>
	 * 
	 * <p>プロパティに定義するフィルタ条件は、下記の通りです。
	 * <p>
	 * <ul>
	 *  <li>プロパティ（親。ダミー）</li>
	 *  <ul>
	 *   <li>重要度（子。コンボボックス）</li>
	 *   <li>受信日時（子。テキスト）</li>
	 *   <ul>
	 *    <li>開始（孫。日時ダイアログ）</li>
	 *    <li>終了（孫。日時ダイアログ）</li>
	 *   </ul>
	 *   <li>出力日時（子。テキスト）</li>
	 *   <ul>
	 *    <li>開始（孫。日時ダイアログ）</li>
	 *    <li>終了（孫。日時ダイアログ）</li>
	 *   </ul>
	 *   <li>ファシリティのターゲット（子。コンボボックス）</li>
	 *   <li>アプリケーション（子。テキスト）</li>
	 *   <li>メッセージ（子。テキスト）</li>
	 *   <li>確認（子。コンボボックス）</li>
	 *   <li>コメント</li>
	 *   <li>コメントユーザ</li>
	 *  </ul>
	 * </ul>
	 * 
	 * @param locale ロケール情報
	 * @return イベント情報フィルタ用プロパティ
	 */
	public static Property getProperty(Locale locale) {

		//重要度
		Property m_priority = new Property(
		        EventFilterConstant.PRIORITY, 
		        WebMessages.getString("priority", locale), 
		        PropertyConstant.EDITOR_SELECT);
		
		//受信日時（自）
		Property m_outputFromDate =	new Property(
		        EventFilterConstant.OUTPUT_FROM_DATE, 
		        WebMessages.getString("start", locale), 
		        PropertyConstant.EDITOR_DATETIME);
		
		//受信日時（至）
		Property m_outputToDate = new Property(
		        EventFilterConstant.OUTPUT_TO_DATE, 
			    WebMessages.getString("end", locale), 
			    PropertyConstant.EDITOR_DATETIME);
		
		//出力日時（自）
		Property m_generationFromDate = new Property(
		        EventFilterConstant.GENERATION_FROM_DATE, 
		        WebMessages.getString("start", locale), 
		        PropertyConstant.EDITOR_DATETIME);
		
		//出力日時（至）
		Property m_generationToDate = new Property(
		        EventFilterConstant.GENERATION_TO_DATE, 
		        WebMessages.getString("end", locale), 
		        PropertyConstant.EDITOR_DATETIME);
		
		//対象ファシリティ種別
		Property m_facilityType = new Property(
		        EventFilterConstant.FACILITY_TYPE, 
		        WebMessages.getString("facility.target", locale), 
		        PropertyConstant.EDITOR_SELECT);
		
		//アプリケーション
		Property m_application = new Property(
		        EventFilterConstant.APPLICATION, 
		        WebMessages.getString("application", locale), 
		        PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		
		//メッセージ
		Property m_message = new Property(
		        EventFilterConstant.MESSAGE, 
		        WebMessages.getString("message", locale), 
		        PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_256);
		
		//確認
		Property m_confirmed = new Property(
		        EventFilterConstant.CONFIRMED, 
		        WebMessages.getString("confirmed", locale), 
		        PropertyConstant.EDITOR_SELECT);
		
		//受信日時
		Property m_outputDate = new Property(
		        EventFilterConstant.OUTPUT_DATE, 
		        WebMessages.getString("receive.time", locale), 
		        PropertyConstant.EDITOR_TEXT);
		
		//出力日時
		Property m_generationDate = new Property(
		        EventFilterConstant.GENERATION_DATE, 
		        WebMessages.getString("output.time", locale), 
		        PropertyConstant.EDITOR_TEXT);

		//確認ユーザ
		Property m_confirmedUser = new Property(
		        EventFilterConstant.CONFIRM_USER, 
		        WebMessages.getString("confirm.user", locale), 
		        PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		
		// コメント
		Property m_comment = new Property(
		        EventFilterConstant.COMMENT, 
		        WebMessages.getString("comment", locale),
		        PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);
		
		// コメントユーザ
		Property m_commentUser = new Property(
		        EventFilterConstant.COMMENT_USER, 
		        WebMessages.getString("comment.user", locale), 
		        PropertyConstant.EDITOR_TEXT, DataRangeConstant.VARCHAR_64);

		//値を初期化
//		Object priorityValues[][] = {
//				{ "", PriorityConstant.STRING_CRITICAL, PriorityConstant.STRING_WARNING, PriorityConstant.STRING_INFO, PriorityConstant.STRING_UNKNOWN},
//				{ "", PriorityConstant.STRING_CRITICAL, PriorityConstant.STRING_WARNING, PriorityConstant.STRING_INFO, PriorityConstant.STRING_UNKNOWN}};
		Object priorityValues[][] = {
                { "", WebMessages.getString("critical", locale), 
                    WebMessages.getString("warning", locale),
                    WebMessages.getString("info", locale),
                    WebMessages.getString("unknown", locale)},
                { "", WebMessages.getString("critical", locale),
                        WebMessages.getString("warning", locale),
                        WebMessages.getString("info", locale),
                        WebMessages.getString("unknown", locale)}};

		m_priority.setSelectValues(priorityValues);
		m_priority.setValue(WebMessages.getString("critical", locale));

		m_outputFromDate.setValue("");
		m_outputToDate.setValue("");
		m_generationFromDate.setValue("");
		m_generationToDate.setValue("");

		Object facilityTypeValues[][] = {
		        { WebMessages.getString("facility.target.all", locale), 
                    WebMessages.getString("facility.target.beneath", locale)},
                { WebMessages.getString("facility.target.all", locale), 
                        WebMessages.getString("facility.target.beneath", locale)}};

		m_facilityType.setSelectValues(facilityTypeValues);
		m_facilityType.setValue(WebMessages.getString("facility.target.all", locale));
		
		m_application.setValue("");
		m_message.setValue("");

		Object confirmedValues[][] = {
				{"", WebMessages.getString("monitor.confirmed", locale), 
				    WebMessages.getString("monitor.unconfirmed", locale)},
				{"", WebMessages.getString("monitor.confirmed", locale), 
				    WebMessages.getString("monitor.unconfirmed", locale)}};

		m_confirmed.setSelectValues(confirmedValues);
		m_confirmed.setValue(WebMessages.getString("monitor.unconfirmed", locale));

		m_outputDate.setValue("");
		m_generationDate.setValue("");

		m_confirmedUser.setValue("");

		m_comment.setValue("");
		m_commentUser.setValue("");


		//変更の可/不可を設定
		m_priority.setModify(PropertyConstant.MODIFY_OK);
		m_outputFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_outputToDate.setModify(PropertyConstant.MODIFY_OK);
		m_generationFromDate.setModify(PropertyConstant.MODIFY_OK);
		m_generationToDate.setModify(PropertyConstant.MODIFY_OK);
		m_facilityType.setModify(PropertyConstant.MODIFY_OK);
		m_application.setModify(PropertyConstant.MODIFY_OK);
		m_message.setModify(PropertyConstant.MODIFY_OK);
		m_confirmed.setModify(PropertyConstant.MODIFY_OK);

		m_outputDate.setModify(PropertyConstant.MODIFY_NG);
		m_generationDate.setModify(PropertyConstant.MODIFY_NG);

		m_confirmedUser.setModify(PropertyConstant.MODIFY_OK);

		m_comment.setModify(PropertyConstant.MODIFY_OK);
		m_commentUser.setModify(PropertyConstant.MODIFY_OK);

		Property property = new Property(null, null, "");

		// 初期表示ツリーを構成。
		property.removeChildren();
		property.addChildren(m_priority);
		property.addChildren(m_outputDate);
		property.addChildren(m_generationDate);
		property.addChildren(m_facilityType);
		property.addChildren(m_application);
		property.addChildren(m_message);
		property.addChildren(m_confirmed);

		// 受信日時
		m_outputDate.removeChildren();
		m_outputDate.addChildren(m_outputFromDate);
		m_outputDate.addChildren(m_outputToDate);

		// 出力日時
		m_generationDate.removeChildren();
		m_generationDate.addChildren(m_generationFromDate);
		m_generationDate.addChildren(m_generationToDate);

		property.addChildren(m_confirmedUser);

		property.addChildren(m_comment);
		property.addChildren(m_commentUser);

		return property;
	}
}
