/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.monitor.util;

import java.util.HashMap;
import java.util.Map;

import com.necsoft.hinemos.webclient.monitor.action.GetEventListTableDefine;
import com.necsoft.hinemos.webclient.monitor.action.GetScopeListTableDefine;
import com.necsoft.hinemos.webclient.monitor.action.GetStatusListTableDefine;

/**
 * 
 **/
public class MonitorMappingUtil {

    private static final Map<Integer, String> EVENT_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
		 * 
		 */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(GetEventListTableDefine.PRIORITY, "priority");
            put(GetEventListTableDefine.RECEIVE_TIME, "receiveTime");
            put(GetEventListTableDefine.OUTPUT_DATE, "outputDate");
            put(GetEventListTableDefine.PLUGIN_ID, "pluginId");
            put(GetEventListTableDefine.MONITOR_ID, "monitorId");
            put(GetEventListTableDefine.MONITOR_DETAIL_ID, "monitorDetailId");
            put(GetEventListTableDefine.FACILITY_ID, "facilityId");
            put(GetEventListTableDefine.SCOPE, "scope");
            put(GetEventListTableDefine.APPLICATION, "application");
            put(GetEventListTableDefine.MESSAGE_ID, "messageId");
            put(GetEventListTableDefine.MESSAGE, "message");
            put(GetEventListTableDefine.CONFIRMED, "confirmed");
            put(GetEventListTableDefine.CONFIRM_USER, "confirmUser");
            put(GetEventListTableDefine.COMMENT, "comment");
        }
    };
    
    private static final Map<Integer, String> STATUS_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
         * 
         */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(GetStatusListTableDefine.PRIORITY, "priority");
            put(GetStatusListTableDefine.PLUGIN_ID, "pluginId");
            put(GetStatusListTableDefine.MONITOR_ID, "monitorId");
            put(GetStatusListTableDefine.MONITOR_DETAIL_ID, "monitorDetailId");
            put(GetStatusListTableDefine.FACILITY_ID, "facilityId");
            put(GetStatusListTableDefine.SCOPE, "scope");
            put(GetStatusListTableDefine.APPLICATION, "application");
            put(GetStatusListTableDefine.UPDATE_TIME, "updateTime");
            put(GetStatusListTableDefine.OUTPUT_TIME, "outputTime");
            put(GetStatusListTableDefine.MESSAGE_ID, "messageId");
            put(GetStatusListTableDefine.MESSAGE, "message");
        }
    };
    
    private static final Map<Integer, String> SCOPE_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
         * 
         */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(GetScopeListTableDefine.PRIORITY, "priority");
            put(GetScopeListTableDefine.FACILITY_ID, "facilityId");
            put(GetScopeListTableDefine.SCOPE, "scope");
        }
    };

    public static final String getEventName(int id) {
        return EVENT_COLUMN_NAME_MAP.get(id);
    }
    

    public static final String getStatusName(int id) {
        return STATUS_COLUMN_NAME_MAP.get(id);
    }
    
    public static final String getScopeName(int id) {
        return SCOPE_COLUMN_NAME_MAP.get(id);
    }

}