/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.action;

import java.util.Locale;

import javax.xml.ws.WebServiceException;

import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.ws.repository.FacilityNotFound_Exception;
import com.clustercontrol.ws.repository.HinemosUnknown_Exception;
import com.clustercontrol.ws.repository.InvalidRole_Exception;
import com.clustercontrol.ws.repository.InvalidUserPass_Exception;
import com.clustercontrol.ws.repository.NodeInfo;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.repository.util.NodePropertyUtil;
import com.necsoft.hinemos.webclient.repository.util.RepositoryEndpointWrapper;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * ノード属性情報を取得するクライアント側アクションクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeProperty {
    
    /**
	 * ノード属性情報を取得します。
	 * 
	 * @param facilityId
	 * @param property
	 * @return ノード属性情報
	 * @throws HinemosWebAccessException 
	 */
	public NodeInfo getProperty(String facilityId, int mode, Locale locale, EndpointManager endpointManager)
	    throws HinemosWebException {
	    
	    NodeInfo nodeInfo = null;
		try {
			if (mode == PropertyConstant.MODE_ADD) {
				nodeInfo = new NodeInfo();
				NodePropertyUtil.setDefaultNode(nodeInfo);
			} else {
				nodeInfo = RepositoryEndpointWrapper.getNode(facilityId, endpointManager);
			}
		} catch (InvalidRole_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access");
		}catch (InvalidUserPass_Exception e) {
            // アクセス権なしの場合
            throw new HinemosWebAccessException("exception.data.access"); 
        } catch (FacilityNotFound_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (HinemosUnknown_Exception e) {
            // データ一覧の取得に失敗しました
            throw new HinemosWebException("exception.data.action");
        } catch (WebServiceException e) {
            // Hinemosマネージャより応答がありませんでした。ログアウトします。
            throw new HinemosWebException("message.force.disconnect");
        }

		return nodeInfo;
	}
}