/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.business;

import java.util.ArrayList;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.repository.RepositoryConstants;
import com.necsoft.hinemos.webclient.repository.action.GetNodeList;
import com.necsoft.hinemos.webclient.repository.action.GetNodeListTableDefine;
import com.necsoft.hinemos.webclient.repository.form.NodeListForm;
import com.necsoft.hinemos.webclient.repository.util.ConvertListUtil;
import com.necsoft.hinemos.webclient.util.EndpointManager;

/**
 * 登録ノードのリストを取得するクライアント側アクションクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeListBusiness {

    public ArrayList<ArrayList<Object>> getNodeList(NodeListForm form, Property condition, 
            EndpointManager endpointManager) throws HinemosWebException {

        ArrayList<ArrayList<Object>> listInfoData = null;
        if (condition == null) {
            listInfoData = getNodeList(endpointManager);
        } else {
            listInfoData = getNodeList(condition, endpointManager);
        }
        
        // Sanitize
        ConvertListUtil.sanitizeNodeInfoData(listInfoData);
        
        // Sort data
        DataProcess.sortData(form, listInfoData,
                GetNodeListTableDefine.SORT_COLUMN_INDEX,
                GetNodeListTableDefine.SORT_ORDER,
                RepositoryConstants.NODE_LIST_TABLE_HEADER_NUM);
        
        return listInfoData;
    }
    
    private ArrayList<ArrayList<Object>> getNodeList(EndpointManager endpointManager)
        throws HinemosWebException {
        ArrayList<ArrayList<Object>> listNodeData;
        // ノード情報一覧データ(NodeInfoData)を取得
        GetNodeList nodeList = new GetNodeList();
        listNodeData = nodeList.getAll(endpointManager);
        return listNodeData;
    }
    
    private ArrayList<ArrayList<Object>> getNodeList(Property condition,
            EndpointManager endpointManager) throws HinemosWebException {
        ArrayList<ArrayList<Object>> listNodeData;
        // ノード情報一覧データ(NodeInfoData)を取得
        GetNodeList nodeList = new GetNodeList();
        listNodeData = nodeList.get(condition, endpointManager);
        
        return listNodeData;
    }
}