/*
 
Copyright (C) NEC Corporation 2013. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2013. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.clustercontrol.repository.bean.AgentCommandConstant;
import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.business.AgentRestartBusiness;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;

/**
 * This class used for display data of agent view
 * 
 */
public class AgentRestartServlet extends CommonServlet {

    private static final long serialVersionUID = -7775038566425028930L;

    private static LogUtils logUtils = LogUtils.getLogUtils(AgentRestartServlet.class);

    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();
        try {
        	restart(request);
        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            //throw new HinemosWebAccessException();
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_INFO, ex.getMessage(),
                    request.getLocale());
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage(),
                    request.getLocale());
        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(),
                    request.getLocale());
        }
        return result;
    }
    
    private void restart(HttpServletRequest request) throws HinemosWebException,Exception {
        HttpSession session = request.getSession(true);
        LoginManager loginManager = null;

        String action = request.getParameter("action");
        
        int agentCommand = -1;
        if("restart".equals(action)){
        	agentCommand = AgentCommandConstant.RESTART;
        }else if ("update".equals(action)) {
        	agentCommand = AgentCommandConstant.UPDATE;
		}else{
			throw new Exception("invalid action parameter.");
		}
        
        String facilityIds[] =  request.getParameterValues("facilityId[]");
        ArrayList<String> facilityIdList = new ArrayList<String>(Arrays.asList(facilityIds));
        
        synchronized(session) {
            loginManager = (LoginManager) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);
            AgentRestartBusiness business = new AgentRestartBusiness();
            business.restartAgent(facilityIdList,agentCommand, loginManager.endpointManager);
        }
        
        return ;
    }
    
}
