/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.Constants;
import com.necsoft.hinemos.webclient.common.DataProcess;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.exception.HinemosWebRemoteException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.repository.business.GetNodeListBusiness;
import com.necsoft.hinemos.webclient.repository.form.NodeListForm;
import com.necsoft.hinemos.webclient.servlet.CommonServlet;
import com.necsoft.hinemos.webclient.util.EndpointManager;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;
import com.necsoft.hinemos.webclient.util.LogUtils;
import com.necsoft.hinemos.webclient.util.LoginManager;
import com.necsoft.hinemos.webclient.util.PopulateBeanUtils;

/**
 * This class used for display data of node view
 * 
 * @version 1.0.0
 * @since 1.0.0
 **/
public class GetNodeListServlet extends CommonServlet {

    private static final long serialVersionUID = -6033566780213986389L;

    private static LogUtils logUtils = LogUtils
            .getLogUtils(GetNodeListServlet.class);

    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException {

        // 中間変数を宣言
        CommonJson result = new CommonJson();
        
        try {
            // get data
            ArrayList<ArrayList<Object>> listInfoData = getNodeList(request);
            
            //convert json
            result = DataProcess.doConvertTableContentToJson(listInfoData);
            
        } catch (HinemosWebAccessException ex) {
            logUtils.info(ex.getMessage());
            throw new HinemosWebAccessException();
        } catch (HinemosWebRemoteException ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_WARNING, ex.getMessage(),
                    request.getLocale());

        } catch (Exception ex) {
            logUtils.error(ex.getMessage(), ex.getCause());
            result = ExceptionHandlerUtils.doBuildCommonJson(
                    ExceptionHandlerUtils.LEVEL_ERROR, ex.getMessage(),
                    request.getLocale());
        }
        return result;
    }

    private ArrayList<ArrayList<Object>> getNodeList(HttpServletRequest request) 
            throws HinemosWebException {

        // 中間変数を宣言
        NodeListForm form = new NodeListForm();
        ArrayList<ArrayList<Object>> listInfoData = null;
        
        PopulateBeanUtils.populateBean(form, request);

        //get loginManager session
        HttpSession session = request.getSession(true);
        LoginManager loginManager = null;
        synchronized(session) {
            loginManager = (LoginManager) session.getAttribute(AccessControlConstants.LOGIN_MANAGER);        
         
            // Check filter
            if (form.isFilter()) {
                listInfoData = processFitler(request, form, loginManager.endpointManager);
            } else {
                listInfoData = processNoneFilter(form, loginManager.endpointManager);
            } 
        }
        
        return listInfoData;
    }

    private ArrayList<ArrayList<Object>> processFitler(HttpServletRequest request, 
            NodeListForm form, EndpointManager endpointManager)
            throws HinemosWebException{
        Property condition = doLoadCondition(request);
        GetNodeListBusiness business = new GetNodeListBusiness();
        return business.getNodeList(form, condition, endpointManager);
    }

    private ArrayList<ArrayList<Object>> processNoneFilter(NodeListForm form, 
            EndpointManager endpointManager) throws HinemosWebException {
        GetNodeListBusiness business = new GetNodeListBusiness();
        return business.getNodeList(form, null, endpointManager);
    }

    private Property doLoadCondition(HttpServletRequest request)
            throws HinemosWebException {

        HttpSession session = request.getSession(true);
        if (session.getAttribute(Constants.NODE_FILTER_PROPERTIES) == null) {
            // HTTPセッションのタイムアウトが発生しました。ログアウトします。
            throw new HinemosWebException("message.sessiontimeout");
        }
        
        Property condition = (Property) session.getAttribute(Constants.NODE_FILTER_PROPERTIES);
        convertCondition(request, condition);

        return condition;
    }
}