/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.repository.util;

import java.util.HashMap;
import java.util.Map;
import com.necsoft.hinemos.webclient.repository.action.GetAgentListTableDefine;
import com.necsoft.hinemos.webclient.repository.action.GetScopeListTableDefine;
import com.necsoft.hinemos.webclient.repository.action.GetNodeListTableDefine;

/**
 * 
 **/
public class RepositoryMappingUtil {

    private static final Map<Integer, String> NODE_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
		 * 
		 */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(GetNodeListTableDefine.FACILITY_ID, "facilityId");
            put(GetNodeListTableDefine.FACILITY_NAME, "facilityName");
            put(GetNodeListTableDefine.PLATFORM, "platform");
            put(GetNodeListTableDefine.IP_ADDRESS, "ipAddress");
            put(GetNodeListTableDefine.DESCRIPTION, "description");
        }
    };
    
    private static final Map<Integer, String> SCOPE_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
         * 
         */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(GetScopeListTableDefine.FACILITY_ID, "facilityId");
            put(GetScopeListTableDefine.FACILITY_NAME, "facilityName");
            put(GetScopeListTableDefine.DESCRIPTION, "description");
        }
    };
    
    private static final Map<Integer, String> AGENT_COLUMN_NAME_MAP = new HashMap<Integer, String>() {
        /**
         * 
         */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(GetAgentListTableDefine.FACILITY_ID, "facilityId");
            put(GetAgentListTableDefine.FACILITY_NAME, "facilityName");
            put(GetAgentListTableDefine.STARTUP_TIME, "startupTime");
            put(GetAgentListTableDefine.LAST_LOGIN, "lastLogin");
            put(GetAgentListTableDefine.NEW_OLD, "newOld");
        }
    };
    
    
    public static final String getNodeName(int id) {
        return NODE_COLUMN_NAME_MAP.get(id);
    }
    
    public static final String getScopeName(int id) {
        return SCOPE_COLUMN_NAME_MAP.get(id);
    }
    
    public static final String getAgentName(int id) {
        return AGENT_COLUMN_NAME_MAP.get(id);
    }
}