/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;

import com.necsoft.hinemos.webclient.accesscontrol.AccessControlConstants;
import com.necsoft.hinemos.webclient.accesscontrol.bean.UserBean;
import com.necsoft.hinemos.webclient.accesscontrol.util.LoginSessionManager;
import com.necsoft.hinemos.webclient.bean.Property;
import com.necsoft.hinemos.webclient.common.PropertyClass;
import com.necsoft.hinemos.webclient.exception.HinemosWebAccessException;
import com.necsoft.hinemos.webclient.exception.HinemosWebException;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.util.DateUtil;
import com.necsoft.hinemos.webclient.util.ExceptionHandlerUtils;

public abstract class CommonServlet extends HttpServlet {

    private static final long serialVersionUID = -886513813590979392L;

    private static Logger m_log = Logger.getLogger(CommonServlet.class);

    private static final List<String> listBypass = new ArrayList<String>();
    static {
        listBypass.add("/language");
        listBypass.add("/login_auth");
        listBypass.add("/layout");
        listBypass.add("/login");
        listBypass.add("/logout");
    }

    public abstract CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException,
            HinemosWebAccessException;

    /**
     * Handles the HTTP <code>POST</code> method.
     * 
     * @param request
     *            servlet request
     * @param response
     *            servlet response
     */
    protected void doPost(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {
        doGet(request, response);
    }

    /**
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code>
     * methods.
     * 
     * @param request
     *            servlet request
     * @param response
     *            servlet response
     */
    protected void doGet(HttpServletRequest request,
            HttpServletResponse response) {
        HttpSession session = request.getSession(true);

        String servletPath = request.getServletPath();

        // Check bypass
        if (!isBypass(servletPath)) {
            // ログインチェック
            if (!LoginSessionManager.checkLogin(session)) {
                // ログインしない場合
                try {
                    if(servletPath.equals("/home"))
                    {
                        response.sendRedirect(request.getContextPath() + "/login");
                        return;
                    }
                    CommonJson result = ExceptionHandlerUtils.doBuildCommonJson(
                            ExceptionHandlerUtils.LEVEL_ERROR, "message.sessiontimeout", request.getLocale());
                    
                    Object errMsg = result.getMessage();
                    if (errMsg != null && errMsg instanceof String) 
                    {
                        errMsg = StringEscapeUtils.escapeHtml4((String) errMsg);
                        result.setMessage(errMsg);
                    }
                    initEnviroment(request, response);
                    writeDataToResponse(response, result);
                } catch (IOException e) {
                    m_log.error(e.getMessage());
                }
                return;
            }
        }
        try {
            initEnviroment(request, response);
            CommonJson result = null;
            try {
                result = process(request, response);
            } catch (HinemosWebAccessException e) {
                result = ExceptionHandlerUtils.doBuildCommonJson(
                        ExceptionHandlerUtils.LEVEL_INFO, "message",
                        "message.accesscontrol.16", request.getLocale());
            }
            if (result != null) {
                Object errMsg = result.getMessage();
                if (errMsg != null && errMsg instanceof String) {
                    errMsg = StringEscapeUtils.escapeHtml4((String) errMsg);
                    result.setMessage(errMsg);
                }
                writeDataToResponse(response, result);
            }
        } catch (Exception e) {
            m_log.error(e.getMessage());
        }
    }

    private void initEnviroment(HttpServletRequest request,
            HttpServletResponse response) throws IOException {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
    }

    protected void writeDataToResponse(HttpServletResponse response,
            CommonJson result) throws IOException {
        PrintWriter outResponse = response.getWriter();
        outResponse.println(result.toJSON());
    }

    /**
     * Get information of url after selvetPath
     * 
     * @param request
     * @return
     */
    protected String getExtraPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String uri = request.getRequestURI();
        int len = uri.length();
        int startAt = uri.indexOf(servletPath) + servletPath.length();
        if ((startAt + 1) < len) { // + sign "/"
            return uri.substring(startAt);
        } else {
            return "";
        }
    }

    /**
     * Initializes the servlet.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    /**
     * Destroys the servlet.
     */
    public void destroy() {
        super.destroy();
    }

    protected void convertCondition(HttpServletRequest request,
            Property condition) throws HinemosWebException {

        String lang = request.getLocale().getLanguage();
        Object[] listCondElement = condition.getChildren();

        String TimeZoneID = request.getParameter("TimeZoneID");
        TimeZone zone;
        if (TimeZoneID == null) {
            zone = TimeZone.getDefault();
        } else {
            zone = TimeZone.getTimeZone(TimeZoneID);
        }
        
        // Get parameter
        for (int count = 0; count < listCondElement.length; count++) {
            Property condElement = (Property) listCondElement[count];

            // Add Child
            if ((condElement.getChildren() != null)
                    && (condElement.getChildren().length > 0)) {
                Object[] listCondEleElement = condElement.getChildren();

                for (int countElement = 0; countElement < listCondEleElement.length; countElement++) {
                    Property condEleElement = (Property) listCondEleElement[countElement];
                    if (request.getParameter(condEleElement.getID()) != null) {
                        if (condEleElement.getEditor().toString()
                                .equals(PropertyClass.DATETIME_EDITOR)) {
                            // This is a DATETIME input
                            Date dateObject = DateUtil
                                    .getDateFromString(request
                                            .getParameter(condEleElement
                                                    .getID()), lang, zone);
                            condEleElement.setValue(dateObject);
                        } else {
                            condEleElement.setValue(request
                                    .getParameter(condEleElement.getID()));
                        }
                    }
                }
            }
            if (request.getParameter(condElement.getID()) != null) {
                String stringObject = request.getParameter(condElement.getID());
                condElement.setValue(stringObject);
            }
        }
    }
    
    public static List<String> getBypassList() {
        return listBypass;
    }

    private static boolean isBypass(String servletPath) {
        if (servletPath == null || servletPath.equals("")) {
            return false;
        }
        return getBypassList().contains(servletPath);
    }

    protected UserBean getUserBean(HttpServletRequest request) {
        return (UserBean) request.getSession(true).getAttribute(
                AccessControlConstants.USER_BEAN);
    }

    protected String getUserName(HttpServletRequest request) {
        UserBean userbean = getUserBean(request);
        if (userbean == null) {
            return null;
        }
        return userbean.getUserName();
    }
}