/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.lang.WebMessages;

public class GetJsLangServlet extends CommonServlet {

    /**
	 * 
	 */
    private static final long serialVersionUID = -8233736099870731348L;

    private static final String STRINGREPLACE = "\\u0024\\u007b([\\w\\d_.-]*)\\u007d";

    private static final String JS_FOLDER = "/js";

    private static final List<String> listAccept = new ArrayList<String>();
    static {
        listAccept.add("/accesscontrol/login.js");
        listAccept.add("/common/lang.js");
        listAccept.add("/common/getTitle.js");
        listAccept.add("/common/headerData.js");
        listAccept.add("/common/formatterData.js");
    }

    private static Logger log = Logger.getLogger(GetJsLangServlet.class);

    /**
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code>
     * methods.
     * 
     * @param request
     *            servlet request
     * @param response
     *            servlet response
     */
    public CommonJson process(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        String sExtraPath = getExtraPath(request);
        StringBuffer ouputBuffer = null;
        String sLocal = request.getLocale() + "";
        PrintWriter outResponse = response.getWriter();

        // Get language properties
        ouputBuffer = getLangProperties(sExtraPath, sLocal);

        // Check existing of file
        if (ouputBuffer == null) {
            return null;
        }

        // Respond data
        outResponse.println(ouputBuffer);
        return null;
    }

    private StringBuffer getLangProperties(String sExtraPath, String sLocal) {
        ServletContext context = getServletContext();
        InputStream inputStream;
        BufferedReader bufferReader;
        StringBuffer ouputBuffer = new StringBuffer();

        if (!isAccepted(sExtraPath)) {
            log.error("Sub path '" + sExtraPath + "' is not accepted");
            return null;
        }

        // Declare input stream
        inputStream = context.getResourceAsStream(JS_FOLDER + sExtraPath);

        // Check null
        if (inputStream == null) {
            log.error("File: '" + JS_FOLDER + sExtraPath + "' does not exist");
            return null;
        }

        // Input and output buffers
        bufferReader = new BufferedReader(new InputStreamReader(inputStream));

        // Pattern and Matcher
        Pattern pattern = Pattern.compile(STRINGREPLACE);
        Matcher matcher = pattern.matcher("");

        // Read line and replace sequentially
        String sLine = null;
        try {
            while ((sLine = bufferReader.readLine()) != null) {
                matcher.reset(sLine);
                while (matcher.find()) {
                    sLocal = sLocal.substring(0, 2);
                    if (sLocal.equals(Locale.ENGLISH + "")) {
                        matcher.appendReplacement(
                                ouputBuffer,
                                WebMessages.getString(matcher.group(1),
                                        WebMessages.getString(matcher.group(1),
                                                Locale.ENGLISH), Locale.ENGLISH));
                    } else {
                        matcher.appendReplacement(ouputBuffer, WebMessages
                                .getString(matcher.group(1), WebMessages
                                        .getString(matcher.group(1),
                                                Locale.JAPANESE),
                                        Locale.JAPANESE));
                    }
                }
                matcher.appendTail(ouputBuffer);
                ouputBuffer.append('\n');
            }

            // Remove the last character '\n'
            ouputBuffer.deleteCharAt(ouputBuffer.length() - 1);
        } catch (IOException e) {
            ouputBuffer = null;
            log.error(e.toString());
        } finally {
            try {
                inputStream.close();
                bufferReader.close();
            } catch (IOException e) {
                log.error(e.toString());
            }
        }

        return ouputBuffer;
    }

    private static boolean isAccepted(String sExtraPath) {
        if (!listAccept.contains(sExtraPath)) {
            return false;
        }

        return true;
    }
}