/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import com.necsoft.hinemos.webclient.common.JsConstant;
import com.necsoft.hinemos.webclient.json.CommonJson;
import com.necsoft.hinemos.webclient.lang.WebMessages;

public class ExceptionHandlerUtils {
    public static final int LEVEL_OK = 0;

    public static final int LEVEL_INFO = 1;
    
    public static final int LEVEL_WARNING = 2;

    public static final int LEVEL_ERROR = 3;

    public static CommonJson doBuildCommonJson(int level, String messageKey,
            String... strParams) {
        String sErrMsg = doLoadMessage(messageKey, strParams);
        CommonJson commonJson = new CommonJson();
        commonJson.setMessage(sErrMsg);
        commonJson.setResult(level);
        return commonJson;
    }

    private static String doLoadMessage(String messageKey, String... strParams) {
        if (messageKey == null) {
            return "";
        }
        return WebMessages.getString(messageKey);
    }

    public static CommonJson doBuildCommonJson(int level, String messageKey,
            Locale locale, String... strParams) {
        String sErrMsg = doLoadMessage(messageKey, locale, strParams);
        CommonJson commonJson = new CommonJson();
        commonJson.setMessage(sErrMsg);
        commonJson.setResult(level);
        return commonJson;
    }

    public static CommonJson doBuildCommonJson(int level, String titleKey,
            String messageKey, Locale locale, String... strParams) {
        Map<String, String> sErrMsg = new HashMap<String, String>();
        
        String title = doLoadMessage(titleKey, locale, strParams);
        String content = doLoadMessage(messageKey, locale, strParams);
        
        sErrMsg.put(JsConstant.MESSAGE_TITLE, title);
        sErrMsg.put(JsConstant.MESSAGE_CONTENT, content);
        CommonJson commonJson = new CommonJson();
        commonJson.setMessage(sErrMsg);
        commonJson.setResult(level);
        return commonJson;
    }

    private static String doLoadMessage(String messageKey, Locale locale,
            String... strParams) {
        if (messageKey == null) {
            return "";
        }
        return WebMessages.getString(messageKey, locale);
    }
}
