/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import com.clustercontrol.bean.PriorityConstant;
import com.necsoft.hinemos.webclient.lang.WebMessages;

public class PriorityMappingUtil {
    private static final Map<Integer, String> PRIORITY_MAP = new HashMap<Integer, String>() {
        /**
		 * 
		 */
        private static final long serialVersionUID = -6098871711845747731L;

        {
            put(PriorityConstant.TYPE_CRITICAL, "critical");
            put(PriorityConstant.TYPE_UNKNOWN, "unknown");
            put(PriorityConstant.TYPE_WARNING, "warning");
            put(PriorityConstant.TYPE_INFO, "info");
        }
    };

    public static final String getString(int id, Locale locale) {
        // Locale locale = Locale.getDefault();
        if (PRIORITY_MAP.containsKey(id)) {
            return WebMessages.getString(PRIORITY_MAP.get(id), locale);
        } else {
            return String.valueOf(id);
        }
    }

    public static final String getName(int id) {
        if (PRIORITY_MAP.containsKey(id)) {
            return PRIORITY_MAP.get(id);
        } else {
            return String.valueOf(id);
        }
    }
}
