/*
 
Copyright (C) NEC Corporation 2012. All Rights Reserved. 
Copyright (C) NEC Soft, Ltd. 2012. All Rights Reserved. 
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.necsoft.hinemos.webclient.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

public class SortOrderUtil {
    private static final String JS_SORT_ORDER_ASC = "asc";

    private static final String JS_SORT_ORDER_DESC = "desc";

    private static final int SER_SORT_ORDER_ASC = 1;

    private static final int SER_SORT_ORDER_DESC = -1;

    private static Map<Integer, String> sortOrdergMap = null;

    private static void initSortOrderMap() {
        sortOrdergMap = new HashMap<Integer, String>();
        sortOrdergMap.put(SER_SORT_ORDER_DESC, JS_SORT_ORDER_DESC);
        sortOrdergMap.put(SER_SORT_ORDER_ASC, JS_SORT_ORDER_ASC);
    }

    public static String getJsString(int index) {
        if (sortOrdergMap == null) {
            initSortOrderMap();
        }

        if (sortOrdergMap.containsKey(index)) {
            return sortOrdergMap.get(index);
        } else {
            return sortOrdergMap.get(SER_SORT_ORDER_ASC);
        }
    }

    public static int getSerInt(String value) {
        if (sortOrdergMap == null) {
            initSortOrderMap();
        }

        if ((value != null) && sortOrdergMap.containsValue(value)) {
            for (Entry<Integer, String> entry : sortOrdergMap.entrySet()) {
                if (value.equals(entry.getValue())) {
                    return entry.getKey();
                }
            }
        }

        return SER_SORT_ORDER_ASC;

    }
}
