// ---------------------------------------------------------------------------
//  Hyper Operating System V4  ե졼                           
//    CRE_MBX API ν                                                      
//                                                                            
//                                    Copyright (C) 1998-2002 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "crembx.h"
#include "analyze.h"


#define CREMBX_MBXID		0
#define CREMBX_MBXATR		1
#define CREMBX_MAXPRI		2
#define CREMBX_MPRIHD		3



// 󥹥ȥ饯
CApiCreMbx::CApiCreMbx()
{
	// ѥ᡼ʸ
	m_iParamSyntax[0] = 0;		// ñȥѥ᡼
	m_iParamSyntax[1] = 3;		// 3ѥ᡼Υ֥å
	m_iParams = 2;
}

// ǥȥ饯
CApiCreMbx::~CApiCreMbx()
{
}



// APIβ
int CApiCreMbx::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	static bool blEx = false;

	if ( strcmp(pszApiName, "CRE_MBX") == 0 )
	{
		return AddParams(pszParams);
	}
	else if ( strcmp(pszApiName, "HOS_MAX_MBXID") == 0 )
	{
		int iId;

		if ( blEx == true )
		{
			return CFG_ERR_MULTIDEF;
		}
		blEx = true;

		if ( (iId = atoi(pszParams)) <= 0 )
		{
			return CFG_ERR_PARAM;
		}
		if ( iId > m_iMaxId )
		{
			m_iMaxId = iId;
		}
		return CFG_ERR_OK;
	}

	return CFG_ERR_NOPROC;
}


// ID ե񤭽Ф
void CApiCreMbx::WriteId(FILE* fp)
{
	int i;

	// ID ľܻǤʤ֥Ȥߤ뤫ɤ
	for ( i = 0; i < m_iObjs; i++ )
	{
		if ( atoi(m_pParamPacks[i]->GetParam(CREMBX_MBXID)) == 0 )
		{
			break;
		}
	}
	if ( i == m_iObjs )
	{
		return;
	}

	fputs("\n\n/* mail box ID definetion */\n", fp);
	for ( i = 0; i < m_iObjs; i++ )
	{
		if ( atoi(m_pParamPacks[i]->GetParam(CREMBX_MBXID)) == 0 )
		{
			fprintf(
				fp,
				"#define %s\t\t%d\n",
				m_pParamPacks[i]->GetParam(CREMBX_MBXID),
				m_iId[i]);
		}
	}

	fprintf( fp,"\n#define TMAX_MBXID\t\t%d\n", m_iMaxId );
}


// cfgե񤭽Ф
void  CApiCreMbx::WriteCfgDef(FILE* fp)
{
	const char* pszParam;
	bool blOutput;
	int  i, j;

	// Ƚ
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*         create mail box objects            */\n"
		"/* ------------------------------------------ */\n"
		, fp);

	// ̤ͥΥå塼إåΰ
	blOutput = false;
	for ( i = 0; i < m_iObjs; i++ )
	{
		pszParam = m_pParamPacks[i]->GetParam(CREMBX_MPRIHD);
		if ( strcmp(pszParam, "NULL") == 0 )
		{
			if ( !blOutput )
			{
				fputs("\n/* message priority que header area */\n", fp);
				blOutput = true;
			}

			fprintf(
				fp,
				"static UB kernel_mbx%d_mprihd[TSZ_MPRIHD(%s)];\n",
				m_iId[i],
				m_pParamPacks[i]->GetParam(CREMBX_MAXPRI));
		}
	}

	if ( m_iObjs > 0 )
	{
		fprintf(
			fp,
			"\n/* mail box control block for rom area */\n"
			"const T_KERNEL_MBXCB_ROM kernel_mbxcb_rom[%d] =\n"
			"\t{\n",
			m_iObjs);

		// ȥ֥å(ROM)
		for ( i = 0; i < m_iObjs; i++ )
		{
			fprintf(
				fp,
				"\t\t{(ATR)(%s), (PRI)(%s), ",
				m_pParamPacks[i]->GetParam(CREMBX_MBXATR),
				m_pParamPacks[i]->GetParam(CREMBX_MAXPRI));
			
			pszParam = m_pParamPacks[i]->GetParam(CREMBX_MPRIHD);
			if ( strcmp(pszParam, "NULL") == 0 )
			{
				fprintf(
					fp,
					"(VP)kernel_mbx%d_mprihd},\n",
					m_iId[i]);
			}
			else
			{
				fprintf(
					fp,
					"(VP)(%s)},\n",
					m_pParamPacks[i]->GetParam(CREMBX_MAXPRI));
			}

		}
		fprintf(fp, "\t};\n");
	}

	// ȥ֥å(RAM)
	if ( m_iObjs > 0 )
	{
		fprintf(
			fp,
			"\n/* mail box control block for ram area */\n"
			"T_KERNEL_MBXCB_RAM kernel_mbxcb_ram[%d];\n",
			m_iObjs);
	}

	// ȥ֥åơ֥
	if ( m_iMaxId > 0 )
	{
		fprintf(
			fp,
			"\n/* mail box control block table */\n"
			"T_KERNEL_MBXCB_RAM *kernel_mbxcb_ram_tbl[%d] =\n"
			"\t{\n",
			m_iMaxId);

		for ( i = 0; i < m_iMaxId; i++ )
		{
			// ID
			for ( j = 0; j < m_iObjs; j++ )
			{
				if ( m_iId[j] == i + 1 )
				{
					break;
				}
			}
			if ( j < m_iObjs )
			{
				// ֥Ȥ¸ߤ
				fprintf(fp, "\t\t&kernel_mbxcb_ram[%d],\n", j);
			}
			else
			{
				// ֥Ȥ̵
				fputs("\t\tNULL,\n", fp);
			}
		}
		fputs("\t};\n", fp);
	}

	// Ŀ
	fprintf(
		fp,
		"\n/* mail box control block count */\n"
		"const INT kernel_mbxcb_cnt = %d;\n",
		m_iMaxId);
}


// cfgե񤭽Ф
void  CApiCreMbx::WriteCfgIni(FILE* fp)
{
	// ֥¸ߥå
	if ( m_iObjs == 0 )
	{
		return;
	}

	// 
	fprintf(
		fp,
		"\t\n\t\n"
		"\t/* initialize mail box control block */\n"
		"\tfor ( i = 0; i < %d; i++ )\n"
		"\t{\n"
		"\t\tkernel_mbxcb_ram[i].mbxcb_rom = &kernel_mbxcb_rom[i];\n"
		"\t}\n",
		m_iObjs);
}


// cfgե뵯ư񤭽Ф
void  CApiCreMbx::WriteCfgStart(FILE* fp)
{
	// ֥¸ߥå
	if ( m_iObjs == 0 )
	{
		return;
	}

	fputs("\tkernel_ini_mbx();\t\t/* initialize mail box */\n", fp);
}


// ---------------------------------------------------------------------------
//  Copyright (C) 1998-2002 by Project HOS                                    
// ---------------------------------------------------------------------------
