// ---------------------------------------------------------------------------
//  Hyper Operating System V4  ե졼                           
//    ǡɤ߹ߥ饹                                                    
//                                                                            
//                                    Copyright (C) 1998-2002 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "defercd.h"
#include "read.h"


// 󥹥ȥ饯
CRead::CRead(FILE *fp, const char *name)
{
	m_fpRead    = fp;
	m_iPhysicalLineNum = m_iLogicalLineNum = 1;
	m_blLineTop = true;
	strncpy(m_szLogicalInputFile, name, MAX_PATH - 1);
	m_szLogicalInputFile[MAX_PATH - 1] = '\0';
}


// ǥȥ饯
CRead::~CRead()
{
}


// ơɤ߹
int CRead::ReadState(char *szState)
{
	bool blEsc   = false;
	bool blSpace = true;	// true ǻϤƬζɤФ
	int  iCount = 0;
	int  iErr;
	int  c;

	for ( ; ; )
	{
		// ʸɤ߹
		if ( (c = fgetc(m_fpRead)) == EOF )
		{
			if ( blEsc || iCount != 0 )
			{
				iErr = CFG_ERR_EOF;	// ͽEOF
			}
			else
			{
				iErr = CFG_ERR_COMPLETE;	// λ
			}
			break;
		}

		// å
		if ( iCount >= READ_MAX_STATE - 1 )
		{
			iErr = CFG_ERR_STATE_LEN;
			break;
		}

		// Ƭ # ʤ饹å
		if ( m_blLineTop && c == '#' )
		{
                       iErr = SkipPreProcessorLine(szState, iCount);
			if ( iErr != CFG_ERR_OK )
			{
				break;
			}
			continue;
		}

		// ʸν
		if ( c == '\n' )
		{
			m_iPhysicalLineNum++;
			m_iLogicalLineNum++;
			m_blLineTop = true;
		}
		else
		{
			m_blLineTop = false;
		}

		// ʸΥå
		if ( isspace(c) || c == '\n' )
		{
			if ( !blSpace )
			{
				szState[iCount++] = ' ';
				blSpace = true;
			}
			continue;
		}
		blSpace = false;

		// ʸν
		if ( c == '\"' || c == '\'' )
		{
			szState[iCount++] = c;
			iErr = ReadString(c, szState, iCount);
			if ( iErr != CFG_ERR_OK )
			{
				break;
			}
			continue;
		}

		// ơȴλʸʤ
		if ( c == ';' )
		{
			iErr = CFG_ERR_OK;
			break;
		}

		// ʸɤ߹
		szState[iCount++] = c;
	}

	// ζʸ
	if ( iCount > 0 && szState[iCount - 1] == ' ' )
	{
		iCount--;
	}

	szState[iCount] = '\0';

	return iErr;
}


// ץץå饤Υå
int CRead::SkipPreProcessorLine(char* szText, int iCountOrg)
{
	int  c;
	int iCount = iCountOrg;
	long tmpLineNum;
	char *p1, *p2;

	for ( ; ; )
	{
		// ʸɤ߹
		if ( (c = fgetc(m_fpRead)) == EOF )
		{
			return CFG_ERR_OK;
		}

		// å
		if ( iCount >= READ_MAX_STATE - 1 )
		{
			return CFG_ERR_STATE_LEN;
		}

		// Υå
		if ( c == '\n' )
		{
			m_iPhysicalLineNum++;
			m_iLogicalLineNum++;

			szText[iCount] = '\0';

			// #line 123 "filename"
			// # 123 "filename"
			// ηΤɤǤդ
			if (strncmp(&szText[iCountOrg], "line", 4) == 0)
				iCountOrg += 4;

			// #line123
			// #12
			// ʤɤӽ
			if (!isspace(szText[iCountOrg]))
				return CFG_ERR_OK;

			// ֹɤ߹
			tmpLineNum = strtol(&szText[iCountOrg], &p1, 10);
			if (p1 == &szText[iCountOrg])
				return CFG_ERR_OK;

			// # 123a
			// ʤɹֹθ;ʬʤΤĤƤӽ
			if (!isspace(*p1) && *p1 != '\0')
				return CFG_ERR_OK;

			// ɤ߹ֹȿ
			m_iLogicalLineNum = tmpLineNum;

			// ե̾õ
			while (isspace(*p1))
				p1++;
			if (*p1 != '\"')
				return CFG_ERR_OK;
			p1++;
			p2 = strchr(p1, '\"');
			if (p2 == NULL)
				return CFG_ERR_OK;
			*p2 = '\0';

			// ե̾ȿ
			strncpy(m_szLogicalInputFile, p1, MAX_PATH - 1);
			m_szLogicalInputFile[MAX_PATH - 1] = '\0';

			return CFG_ERR_OK;
		}

		// ʸɤ߹
		szText[iCount++] = c;
	}
}


// ʸɤ߹
int CRead::ReadString(int cDelimiter, char* szText, int& iCount)
{
	bool blEsc  = false;
	int c;

	for ( ; ; )
	{
		// ʸɤ߹
		if ( (c = fgetc(m_fpRead)) == EOF )
		{
			return CFG_ERR_EOF;	// ͽEOF
		}

		// å
		if ( iCount >= READ_MAX_STATE - 1 )
		{
			return CFG_ERR_STATE_LEN;
		}

		// ԥå
		if ( c == '\n' )
		{
			return CFG_ERR_CR;		// ʲ
		}

		// ʸ
		szText[iCount++] = c;

		// \ μ̵˥å
		if ( blEsc )
		{
			blEsc  = false;
			continue;
		}

		// \ Υå
		if ( c == '\\' )
		{
			blEsc  = true;
			continue;
		}

		blEsc  = false;

		// ǥߥʸʤ鴰λ
		if ( c == cDelimiter )
		{
			return CFG_ERR_OK;
		}
	}
}


// ---------------------------------------------------------------------------
//  Copyright (C) 1998-2002 by Project HOS                                    
// ---------------------------------------------------------------------------
