/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ץåݲݡͥ (Ω H8/300H )                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */



#ifndef __HOS_V4__H83__hospac_h__
#define __HOS_V4__H83__hospac_h__



#include "itron.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* ߥޥ */
#define H83_IMSK_I_BIT		0x80	/* ߥޥӥå */
#define H83_IMSK_UI_BIT		0x40	/* 桼ӥåȡߥޥӥå */

#define H38_IMSK_LEVEL0		0x00								/* ץ饤ƥ٥0/1 */
#define H38_IMSK_LEVEL1		(H83_IMSK_I_BIT)					/* ץ饤ƥ٥1Τߵ */
#define H38_IMSK_LEVEL2		(H83_IMSK_I_BIT | H83_IMSK_UI_BIT)	/* ٤ƶػ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

typedef UB	IMSK;		/* ߥޥ */


/* ƥȾ¸֥å */
typedef struct t_hos_pac_ctxinf
{
	VP sp;
} T_HOSPAC_CTXINF;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

extern UB kernel_h83_imsk;		/* ߥޥ */
extern UB kernel_h83_ibmsk;		/* ߥ١ޥ */



/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

void hospac_ini_sys(void);			/* ƥν */

void hospac_dis_int(void);			/* ߶ػ */
void hospac_ena_int(void);			/* ߵ */

void hospac_cre_ctx_asm(T_HOSPAC_CTXINF *pk_ctxinf,
					VP sp, FP task, VP_INT exinf);			/* ¹ԥƥȤκ(֥) */
#define hospac_cre_ctx(pk_ctxinf, exinf, task, stksz, stk)	\
	hospac_cre_ctx_asm(pk_ctxinf, ((VP)((UB *)(stk) + ((stksz) & 0xfffffffc))), task, exinf)
															/* ֥¦Թ礬褦˰ؤ */
#define hospac_del_ctx(pk_ctxinf)	do {} while (0)			/* ¹ԥƥȤκ() */
void hospac_swi_ctx(T_HOSPAC_CTXINF *pk_pre_ctxinf,
						T_HOSPAC_CTXINF *pk_nxt_ctxinf);	/* ¹ԥƥȤ */
#define hospac_idle()	do {} while (0)						/* ɥư(⤷ʤ) */


ER chg_imsk(IMSK imsk);				/* ߥޥΥ١ͤѹ */
ER get_imsk(IMSK *p_imsk);			/* ߥޥΥ١ͤλ */

ER fchg_imsk(IMSK imsk);			/* ߤγߥޥͤζѹ */
ER fget_imsk(IMSK *p_imsk);			/* ߤγߥޥͤζ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__H83__hospac_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
