/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå ϥɥ                               */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_cyc_h__
#define __HOS_V4__knl_cyc_h__



#include "knl_hos.h"
#include "knl_tim.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* IDϰ */
#define KERNEL_TMIN_CYCID	TMIN_CYCID			/* ϥɥIDκǾ */
#define KERNEL_TMAX_CYCID	(KERNEL_TMIN_CYCID + kernel_cyccb_cnt - 1)
												/* ϥɥIDκ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* ϥɥ饳ȥ֥å(ROM) */
typedef struct t_kernel_cyccb_rom
{
	ATR    cycatr;		/* ϥɥ° */
	VP_INT exinf;		/* ϥɥγĥ */
	FP     cychdr;		/* ϥɥεư */
	RELTIM cyctim;		/* ϥɥεư */
} T_KERNEL_CYCCB_ROM;

/* ϥɥ饳ȥ֥å(RAM) */
typedef struct t_kernel_cyccb_ram
{
	T_KERNEL_TIM timobj;		/* ޥ֥ȤѾ */
	RELTIM       lefttim;		/* ϥɥΤ򼡤˵ưޤǤλ */
	const T_KERNEL_CYCCB_ROM *cyccb_rom;	/* ϥɥ饳ȥ֥åROMؤΥݥ */
} T_KERNEL_CYCCB_RAM;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

/* ϥɥ */
extern       T_KERNEL_CYCCB_RAM *kernel_cyccb_ram_tbl[];	/* ϥɥ饳ȥ֥åơ֥ */
extern const INT kernel_cyccb_cnt;							/* ϥɥ饳ȥ֥åĿ */

#define KERNEL_CYCID_TO_CYCCB_RAM(cycid)	(kernel_cyccb_ram_tbl[(cycid) - KERNEL_TMIN_CYCID])
															/* ϥɥIDCYCCB RAMɥ쥹 */



/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* ϥɥ */
void    kernel_ini_cyc(void);								/* ϥɥν */
void    kernel_cyc_hdr(T_KERNEL_TIM *timobj, RELTIM tic);	/* ϥɥΥޥϥɥ */
ER      sta_cyc(ID cycid);									/* ϥɥư */
ER      stp_cyc(ID cycid);									/* ϥɥư */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_cyc_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
