/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ץץ                           */
/*   ůؼԤο                                             */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */



#include <stdio.h>
#include "kernel.h"
#include "kernel_id.h"
#include "sample.h"



#define LEFT_FORK(id)	((id) % 5 + 1)
#define RIGHT_FORK(id)	(id)


static char status[] = "TTTTT\n";



/* ᥤؿ */
int main()
{
	/* HOS-V4 γ */
	sta_hos();
	
	return 0;
}


/* ATT_INI Ͽδؿ */
void SampleInitialize(VP_INT exinf)
{
	/* ư */
	act_tsk(TSKID_OUTPUT);
	act_tsk(TSKID_PHILOSOPHER1);
	act_tsk(TSKID_PHILOSOPHER2);
	act_tsk(TSKID_PHILOSOPHER3);
	act_tsk(TSKID_PHILOSOPHER4);
	act_tsk(TSKID_PHILOSOPHER5);
}


/* ůؼԥ */
void PhilosopherTask(VP_INT exinf)
{
	INT id;

	id = (INT)exinf;

	/* ĶФ르ꥺ */
	for ( ; ; )
	{
		/* ŬʻǺǤߤ */
		status[id -1] = 'T';
		snd_mbf(MBFID_OUTPUT, status, 7);
		dly_tsk((rand() % 100) * 10 + 500);

		/* ΥեޤǴ */
		status[id -1] = 'W';
		snd_mbf(MBFID_OUTPUT, status, 7);
		for ( ; ; )
		{
			wai_sem(LEFT_FORK(id));
			if ( pol_sem(RIGHT_FORK(id)) == E_OK )
			{
				break;
			}
			sig_sem(LEFT_FORK(id));
			dly_tsk((rand() % 10 + 1) * 10);	/* ŬԤ */
		}

		/*  */
		status[id -1] = 'E';
		snd_mbf(MBFID_OUTPUT, status, 7);
		dly_tsk(1000);

		/* ե */
		sig_sem(LEFT_FORK(id));
		sig_sem(RIGHT_FORK(id));
	}
}


void OutputTask(VP_INT exinf)
{
	char buf[128];

	for ( ; ; )
	{
		rcv_mbf(MBFID_OUTPUT, buf);
		printf("%s", buf);
	}
}



/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
