; --------------------------------------------------------------------------- 
;  Hyper Operating System V4  ITRON4.0 Real-Time OS                     
;    ץåݲݡͥ (ARM)                                   
;    㳰ϥɥ                                                             
;                                                                             
;                                     Copyright (C) 1998-2002 by Project HOS  
;                                     http://sourceforge.jp/projects/hos/     
; --------------------------------------------------------------------------- 


				INCLUDE	pacarm.inc



				AREA	inthdr_code, CODE, READONLY

				EXPORT	_HOS_CpuExceptionHandler

; ----------------------------------------------
;  CPU㳰ϥɥ
; ----------------------------------------------
				IMPORT	kernel_sta_exc				; CPU㳰ϥɥ鳫Ͻ
				IMPORT	kernel_end_exc				; CPU㳰ϥɥ齪λ
				IMPORT	kernel_exe_exc				; CPU㳰ϥɥμ¹
				IMPORT	kernel_int_sp				; ѥåɥ쥹
				IMPORT	_HOS_int_cnt				; ߥͥȲ
				IMPORT	_HOS_int_sp					; ߻å
				
_HOS_CpuExceptionHandler
			; ---- System⡼ɤ˰ܹԤƥ쥸
				mov		r13, #I_Bit:OR:F_Bit:OR:Mode_SYS
				msr		cpsr_csxf, r13
				stmfd	sp!, {r1-r3, ip, lr}		; ѥ쥸

			; ---- Υ⡼ɤäspsr¸
				mov		r1, #I_Bit:OR:F_Bit:OR:Mode_UND
				msr		cpsr_c, r1
				mrs		r1, spsr					; spsr Ф
				mov		r2, lr						; ¸
				
			; ---- USR⡼ɤ˰ܹ
				mov		r3, #I_Bit:OR:F_Bit:OR:Mode_USR
				msr		cpsr_c, r3
				
			; ---- 쥸
				stmfd	sp!, {r0-r2}				; a1, spsr_irq, lr_irq ¸
				
			; ---- ¿ųߥå
				ldr		r0, =_HOS_int_cnt
				ldr		r1, [r0]					; ߥͥȥ󥿼
				cmp		r1, #0
				add		r1, r1, #1					; ߥͥȥ󥿥󥯥
				str		r1, [r0]
				bne		MultipleInt					; ʤʬ
				
			; ---- åؤ
				ldr		r0, =_HOS_int_sp
				str		sp, [r0]					; åݥ󥿤
				ldr		r0, =kernel_int_sp
				ldr		sp, [r0]					; ѥå

			; ---- CPU㳰ϥɥγ
				bl		kernel_sta_exc				; CPU㳰ϥɥ鳫Ͻ
				bl		kernel_exe_exc				; ߽¹
			
			; ---- å
				ldr		r0, =_HOS_int_sp
				ldr		sp, [r0]					; åݥ󥿤
			
			; ---- ߥͥȥȥǥ
				ldr		r0, =_HOS_int_cnt
				mov		r1, #0
				str		r1, [r0]					; ߥͥȥ󥿥ꥢ
			
			; ---- ٱǥѥå¹
				bl		kernel_end_exc				; ٱǥѥå¹
			
			; ---- CPU㳰ϥɥ餫
ReturnExc		
				IMPORT	_HOS_swi_ret
				ldmfd	sp!, {r0-r2}
				ldr		r3, =_HOS_swi_ret
				stmia	r3, {r0-r2}					; ǡ
				ldmfd	sp!, {r1-r3, ip, lr}		; 쥸
				mov		a1, #2
				swi		0x10


			;---- ν
MultipleInt
			; ---- ߽
				bl		kernel_sta_exc				; CPU㳰ϥɥ鳫Ͻ

			; ---- ߥͥȥȥǥ
				ldr		r0, =_HOS_int_sp
				ldr		r1, [r0]
				add		r1, r1, #1
				str		r1, [r0]

				b		ReturnExc



				END


; --------------------------------------------------------------------------- 
;  Copyright (C) 1998-2002 by Project HOS                                     
; --------------------------------------------------------------------------- 
