/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ٥ȥե饰                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"
#include "knl_mem.h"



/* ٥ȥե饰ȥ֥å(ưŪ) */
typedef struct t_kernel_flgcb
{
	T_KERNEL_FLGCB_RAM flgcb_ram;	/* ٥ȥե饰ȥ֥å(RAM) */
	T_KERNEL_FLGCB_ROM flgcb_rom;	/* ٥ȥե饰ȥ֥å(ROM) */
} T_KERNEL_FLGCB;



/* ٥ȥե饰(ͥؿ) */
ER kernel_cre_flg(
		ID           flgid,		/* оݤΥ٥ȥե饰IDֹ */
		const T_CFLG *pk_cflg)	/* ٥ȥե饰줿ѥåȤؤΥݥ */
{
	T_KERNEL_FLGCB     *flgcb;
	T_KERNEL_FLGCB_RAM *flgcb_ram;
	T_KERNEL_FLGCB_ROM *flgcb_rom;

	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_RSATR
	if ( pk_cflg->flgatr & ~(TA_TFIFO | TA_TPRI | TA_WSGL | TA_WMUL | TA_CLR) )
	{
		return E_RSATR;
	}
#endif

	/* ٥ȥե饰ѥγ */
	flgcb = (T_KERNEL_FLGCB *)kernel_alc_mem(sizeof(T_KERNEL_FLGCB));
	if ( flgcb == NULL )
	{
		return E_NOMEM;		/* ­ */
	}

	/* ٥ȥե饰 */
	flgcb_ram = &flgcb->flgcb_ram;
	flgcb_rom = &flgcb->flgcb_rom;
	flgcb_rom->flgatr  = pk_cflg->flgatr;
	flgcb_rom->iflgptn = pk_cflg->iflgptn;
	mknl_ini_que(&flgcb_ram->que);
	flgcb_ram->flgptn    = flgcb_rom->iflgptn;
	flgcb_ram->flgcb_rom = flgcb_rom;

	/* ơ֥ɲ */
	KERNEL_FLGID_TO_FLGCB_RAM(flgid) = flgcb_ram;

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
