/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå åХåե                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"



/* åХåեؤ */
ER snd_mbf(
		ID   mbfid,		/* оݤΥåХåեIDֹ */
		VP   msg,		/* åƬ */
		UINT msgsz)		/* åΥ(Хȿ) */
{
	const T_KERNEL_MBFCB_ROM *mbfcb_rom;
	T_KERNEL_MBFCB_RAM       *mbfcb_ram;
	T_MKNL_TCB               *mtcb;
	T_KERNEL_MBFDAT          mbfdat;
	ER                       ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mbfid < KERNEL_TMIN_MBFID || mbfid > KERNEL_TMAX_MBFID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ƥȥå */
#ifdef HOS_ERCHK_E_CTX
	if ( mknl_sns_wai() )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_CTX;	/* ƥ */
	}
#endif

	mbfcb_ram = KERNEL_MBFID_TO_MBFCB_RAM(mbfid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbfcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	mbfcb_rom = mbfcb_ram->mbfcb_rom;

	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR
	if ( msg == NULL || msgsz > mbfcb_rom->maxmsz )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_PAR;	/* ѥ᡼ */		
	}
#endif

	/*  */
	ercd = kernel_snd_mbf(mbfcb_rom, mbfcb_ram, msg, msgsz);
	if ( ercd == E_TMOUT )	/* ॢȤʤ */
	{
		/* Ԥ֤ˤ */
		mtcb = mknl_get_run_tsk();
		mbfdat.msg   = msg;
		mbfdat.msgsz = msgsz;
		mtcb->data   = (VP_INT)&mbfdat;
		mknl_wai_tsk(mtcb, TTW_SMBF);
		mknl_add_que(&mbfcb_ram->sndque, mtcb, mbfcb_rom->mbfatr);	/* Ԥɲ */

		ercd = (ER)mknl_exe_dsp();	/* ǥѥåμ¹ */
		mknl_exe_tex();				/* 㳰μ¹ */
	}
	
	mknl_unl_sys();		/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
