/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include <string.h>
#include "knl_tsk.h"
#include "knl_mem.h"



/* (ͥ) */
ER kernel_cre_tsk(
		ID           tskid,		/* оݤΥIDֹ */
		const T_CTSK *pk_ctsk)	/* 줿ѥåȤؤΥݥ */
{
	T_KERNEL_TCB_RAM *tcb_ram;
	T_KERNEL_TCB_ROM *tcb_rom;
	SIZE memsize;
	UB   *memptr;
	
	/* ɬפʥꥵ׻ */
	memsize = sizeof(T_KERNEL_TCB_RAM) + sizeof(T_KERNEL_TCB_ROM);
	if ( pk_ctsk->stk == NULL )
	{
		memsize += pk_ctsk->stksz;	/* åû */
	}
	
	/*  */
	memptr = (UB *)kernel_alc_mem(memsize);
#ifdef HOS_ERCHK_E_NOMEM
	if ( memptr == NULL )
	{
		return E_NOMEM;		/* ­ */
	}
#endif

	/* ݥ */	
	tcb_ram  = (T_KERNEL_TCB_RAM *)memptr;
	memptr  += sizeof(T_KERNEL_TCB_RAM);
	tcb_rom  = (T_KERNEL_TCB_ROM *)memptr;
	if ( pk_ctsk->stk == NULL )
	{
		memptr  += sizeof(T_KERNEL_TCB_ROM);
		tcb_rom->stk = (VP)memptr;
	}
	else
	{
		tcb_rom->stk = pk_ctsk->stk;
	}

	/* ̥ͥ륿ν */
	memset(&tcb_ram->mtcb, 0, sizeof(tcb_ram->mtcb));
	mknl_ini_tsk(&tcb_ram->mtcb);

	/*  */
	tcb_ram->actcnt  = 0;					/* ư׵ᥭ塼󥰿 */
	tcb_ram->suscnt  = 0;					/* SUSPEND׵ͥȿ */
	tcb_ram->wupcnt  = 0;					/* ׵ᥭ塼󥰿 */
	tcb_ram->tcb_rom = tcb_rom;				/* ȥ֥åROMؤΥݥ */
	tcb_rom->tskatr  = pk_ctsk->tskatr;		/* ° */
	tcb_rom->exinf   = pk_ctsk->exinf;		/* γĥ */
	tcb_rom->task    = pk_ctsk->task;		/* εư */
	tcb_rom->itskpri = pk_ctsk->itskpri;	/* εưͥ */
	tcb_rom->stksz   = pk_ctsk->stksz;		/* ΥåΥʥХȿ */

	/* ȥ֥åơ֥Ͽ */
	KERNEL_TSKID_TO_TCB_RAM(tskid) = tcb_ram;

	/* ¹Ծ֤ */
	if ( pk_ctsk->tskatr & TA_ACT )
	{
		/* ¹ԥƥϿ */
		mknl_sta_tsk(
				&tcb_ram->mtcb,			/* Ͽ륿 */
				tcb_rom->exinf,			/* γĥ */
				(FP)kernel_task_entry,	/* εư */
				tcb_rom->itskpri,		/* εưͥ */
				tcb_rom->stksz,			/* Υåΰ襵 */
				tcb_rom->stk			/* ΥåΰƬ */
			);	
		
		mknl_exe_dsp();		/* ǥѥåμ¹ */
		mknl_exe_tex();		/* 㳰μ¹ */
	}

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
