/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* εư(ưɻ) */
ER sta_tsk(
		ID tskid,		/* ưоݤΥIDֹ */
		VP_INT stacd)	/* εư */
{
	const T_KERNEL_TCB_ROM *tcb_rom;
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ϰϥå */
#ifdef HOS_ERCHK_E_ID
	if ( tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ID饿ȥ֥åRAM */
	tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( tcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	/* ֥Ȥξ֥å */
#ifdef HOS_ERCHK_E_OBJ
	if ( mknl_get_tskstat(&tcb_ram->mtcb) != TTS_DMT )	/* ٻ߾֤Ǥʤ */
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_OBJ;	/* ֥Ⱦ֥顼 */
	}
#endif
	
	/* ȥ֥åROM */
	tcb_rom = tcb_ram->tcb_rom;
	
	/* ¹ԥƥϿ */
	mknl_sta_tsk(
				&tcb_ram->mtcb,			/* Ͽ륿 */
				stacd,					/* γĥ */
				(FP)kernel_task_entry,	/* εư */
				tcb_rom->itskpri,		/* εưͥ */
				tcb_rom->stksz,			/* Υåΰ襵 */
				tcb_rom->stk			/* ΥåΰƬ */
			);	
	tcb_ram->suscnt  = 0;
	tcb_ram->wupcnt  = 0;
	
	mknl_exe_dsp();		/* ǥѥåμ¹ */
	mknl_exe_tex();		/* 㳰μ¹ */
	
	mknl_unl_sys();		/* ƥΥå */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
