
#ifndef _OPERATOR_H_
#define _OPERATOR_H_

#include "sysDep.h"
#include "TArray.h"
#include "PtrArray.h"
#include "Substr.h"


namespace Houken {

    class Operator {

    public:
        Operator(void);
        ~Operator();

        // register operator precedence 'prec' of rule 'sIdent' 
        bool entry(Substr& sIdent, u32 prec);

        // sort all precedence 
        void sort(void);

        // return 1 level higher than prec
        // if none, return 0
        u32 getHigher(Substr& sIdent, u32 prec);

        // return true if sIdent is target rule name
        bool isOperand(Substr& sIdent);

        TArray<Substr>* expIdents(void) { return &_expIdents; }

        // get precedence array of rule 'sIdent'
        TArray<u32>* getPrecs(Substr sIdent);

    protected:
        TArray<Substr>          _expIdents; // target rule names 
        PtrArray<TArray<u32> >  _precs; // precedence arrays per rule 

        // index of sIdent; if none return -1
        int _getIdx(Substr sIdent);

    };
}

#endif /* _OPERATOR_H_ */
