#pragma once

// No security warning
#define _CRT_SECURE_NO_DEPRECATE
// No cast between int and pointer cast
#pragma warning(disable: 4311)
#pragma warning(disable: 4312)

#include "boost/shared_ptr.hpp"
#include "boost/shared_array.hpp"
#include <string.h>
#include <windows.h>
#include "hsp3plugin.h"

// Allocate memory and copy string to it
// Return its pointer (auto delete).
inline boost::shared_array<char> copystr(const char *str){
	char *p = new char[strlen(str) + 1];
	strcpy(p, str);
	return boost::shared_array<char>(p);
}
// Allocate memory and copy string to it (ignore '\r')
// Return its pointer (auto delete).
inline boost::shared_array<char> copystr_nocr(const char *str){
	char *p = new char[strlen(str) + 1];
	const char *pin = str;
	char *pout = p;
	while(*pin){
		if(*pin != '\r'){
			*pout = *pin;
			pout++;
		}
		pin++;
	}
	*pout = '\0';
	return boost::shared_array<char>(p);
}

struct FUNC_RESULT{
	// return value
	int ref_ival;
	double ref_dval;
	char ref_sval[1024];

	// HSPVAR_FLAG_INT
	// HSPVAR_FLAG_DOUBLE
	// HSPVAR_FLAG_STR
	int ref_type;
};

/*
initfuncs.cpp
*/
#define FUNCS_MAX 0x0fff
typedef void (*HSP_ANSIC_FUNC)(FUNC_RESULT *result);
extern HSP_ANSIC_FUNC g_funcs[FUNCS_MAX];
void initfuncs();

/*
ctype.h
*/
#define CTYPE_START 0x0000
// int isalnum(int c);
void hsp_isalnum(FUNC_RESULT *result);
// int isalpha(int c);
void hsp_isalpha(FUNC_RESULT *result);
// int isctrl(int c);
void hsp_isctrl(FUNC_RESULT *result);
//int isdigit(int c);
void hsp_isdigit(FUNC_RESULT *result);
//
void hsp_isgraph(FUNC_RESULT *result);
void hsp_islower(FUNC_RESULT *result);
void hsp_isprint(FUNC_RESULT *result);
void hsp_ispunct(FUNC_RESULT *result);
void hsp_isspace(FUNC_RESULT *result);
void hsp_isupper(FUNC_RESULT *result);
void hsp_isxdigit(FUNC_RESULT *result);
void hsp_tolower(FUNC_RESULT *result);
void hsp_toupper(FUNC_RESULT *result);

/*
stdio.h
*/
#define STDIO_START 0x0100
void hsp_fopen(FUNC_RESULT *result);
void hsp_fclose(FUNC_RESULT *result);
void hsp_freopen(FUNC_RESULT *result);

void hsp_fgetc(FUNC_RESULT *result);
void hsp_getchar(FUNC_RESULT *result);
void hsp_fgets(FUNC_RESULT *result);
void hsp_gets(FUNC_RESULT *result);
void hsp_sscanf(FUNC_RESULT *result);
void hsp_fscanf(FUNC_RESULT *result);
void hsp_scanf(FUNC_RESULT *result);

void hsp_fputc(FUNC_RESULT *result);
void hsp_putchar(FUNC_RESULT *result);
void hsp_fputs(FUNC_RESULT *result);
void hsp_puts(FUNC_RESULT *result);
void hsp_sprintf(FUNC_RESULT *result);
void hsp_fprintf(FUNC_RESULT *result);
void hsp_printf(FUNC_RESULT *result);

void hsp_fread(FUNC_RESULT *result);
void hsp_fwrite(FUNC_RESULT *result);

void hsp_clearerr(FUNC_RESULT *result);
void hsp_feof(FUNC_RESULT *result);
void hsp_ferror(FUNC_RESULT *result);
void hsp_fflush(FUNC_RESULT *result);
void hsp_fgetpos(FUNC_RESULT *result);
void hsp_fseek(FUNC_RESULT *result);
void hsp_fsetpos(FUNC_RESULT *result);
void hsp_ftell(FUNC_RESULT *result);
void hsp_perror(FUNC_RESULT *result);
void hsp_remove(FUNC_RESULT *result);
void hsp_rename(FUNC_RESULT *result);
void hsp_rewind(FUNC_RESULT *result);
void hsp_setbuf(FUNC_RESULT *result);
void hsp_setvbuf(FUNC_RESULT *result);
void hsp_tmpfile(FUNC_RESULT *result);
void hsp_tmpnam(FUNC_RESULT *result);
void hsp_ungetc(FUNC_RESULT *result);
void hsp_vfprintf(FUNC_RESULT *result);
void hsp_vprintf(FUNC_RESULT *result);
void hsp_vsprintf(FUNC_RESULT *result);

/*
string.h
*/
#define STRING_START 0x0200
void hsp_memcpy(FUNC_RESULT *result);
void hsp_memmove(FUNC_RESULT *result);
void hsp_strcpy(FUNC_RESULT *result);
void hsp_strncpy(FUNC_RESULT *result);
void hsp_strcat(FUNC_RESULT *result);
void hsp_strncat(FUNC_RESULT *result);
void hsp_memcmp(FUNC_RESULT *result);
void hsp_strcmp(FUNC_RESULT *result);
void hsp_strcoll(FUNC_RESULT *result);
void hsp_strncomp(FUNC_RESULT *result);
void hsp_strxfrm(FUNC_RESULT *result);
void hsp_memchr(FUNC_RESULT *result);
void hsp_strchr(FUNC_RESULT *result);
void hsp_strcspn(FUNC_RESULT *result);
void hsp_strpbrk(FUNC_RESULT *result);
void hsp_strrchr(FUNC_RESULT *result);
void hsp_strspn(FUNC_RESULT *result);
void hsp_strstr(FUNC_RESULT *result);
void hsp_strtok(FUNC_RESULT *result);
void hsp_memset(FUNC_RESULT *result);
void hsp_strerror(FUNC_RESULT *result);

/*
math.h
*/
#define MATH_START 0x0300
void hsp_hugevalfunc(FUNC_RESULT *result);

void hsp_acos(FUNC_RESULT *result);
void hsp_asin(FUNC_RESULT *result);
void hsp_atan(FUNC_RESULT *result);
void hsp_atan2(FUNC_RESULT *result);
void hsp_cosh(FUNC_RESULT *result);
void hsp_sinh(FUNC_RESULT *result);
void hsp_tanh(FUNC_RESULT *result);
void hsp_frexp(FUNC_RESULT *result);
void hsp_ldexp(FUNC_RESULT *result);
void hsp_log10(FUNC_RESULT *result);
void hsp_modf(FUNC_RESULT *result);
void hsp_pow(FUNC_RESULT *result);
void hsp_ceil(FUNC_RESULT *result);
void hsp_floor(FUNC_RESULT *result);
void hsp_fmod(FUNC_RESULT *result);

/*
time.h
*/
#define TIME_START 0x0400
void hsp_clock(FUNC_RESULT *result);
void hsp_difftime(FUNC_RESULT *result);
void hsp_mktime(FUNC_RESULT *result);
void hsp_time(FUNC_RESULT *result);
void hsp_asctime(FUNC_RESULT *result);
void hsp_ctime(FUNC_RESULT *result);
void hsp_gmtime(FUNC_RESULT *result);
void hsp_localtime(FUNC_RESULT *result);
void hsp_strftime(FUNC_RESULT *result);
